/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationFlushRequester;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicationFlushRequester {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicationFlushRequester.class);
    private Configuration conf;
    private Runnable requester;
    private RegionReplicationFlushRequester flushRequester;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.conf.setInt("hbase.region.read-replica.sink.flush.min-interval.secs", 1);
        this.requester = (Runnable)Mockito.mock(Runnable.class);
        this.flushRequester = new RegionReplicationFlushRequester(this.conf, this.requester);
    }

    @Test
    public void testRequest() throws InterruptedException {
        this.flushRequester.requestFlush(100L);
        ((Runnable)Mockito.verify((Object)this.requester, (VerificationMode)Mockito.times((int)1))).run();
        this.flushRequester.requestFlush(200L);
        ((Runnable)Mockito.verify((Object)this.requester, (VerificationMode)Mockito.times((int)1))).run();
        Thread.sleep(2000L);
        ((Runnable)Mockito.verify((Object)this.requester, (VerificationMode)Mockito.times((int)2))).run();
        Thread.sleep(2000L);
        this.flushRequester.requestFlush(300L);
        ((Runnable)Mockito.verify((Object)this.requester, (VerificationMode)Mockito.times((int)3))).run();
    }

    @Test
    public void testCancelFlushRequest() throws InterruptedException {
        this.flushRequester.requestFlush(100L);
        this.flushRequester.requestFlush(200L);
        ((Runnable)Mockito.verify((Object)this.requester, (VerificationMode)Mockito.times((int)1))).run();
        this.flushRequester.recordFlush(300L);
        Thread.sleep(2000L);
        ((Runnable)Mockito.verify((Object)this.requester, (VerificationMode)Mockito.times((int)1))).run();
    }
}

