/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestChangeStoreFileTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestChangeStoreFileTracker.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    @Rule
    public final TableNameTestRule tableName = new TableNameTestRule();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testCreateError() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).setValue("hbase.store.file-tracker.migration.dst.impl", StoreFileTrackerFactory.Trackers.FILE.name()).build();
        UTIL.getAdmin().createTable(td);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testModifyError1() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).build();
        UTIL.getAdmin().createTable(td);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.FILE.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testModifyError2() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).build();
        UTIL.getAdmin().createTable(td);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.Trackers.FILE.name()).setValue("hbase.store.file-tracker.migration.dst.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testModifyError3() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).build();
        UTIL.getAdmin().createTable(td);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).setValue("hbase.store.file-tracker.migration.dst.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
    }

    private TableDescriptor createTableAndChangeToMigrationTracker() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).build();
        UTIL.getAdmin().createTable(td);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).setValue("hbase.store.file-tracker.migration.dst.impl", StoreFileTrackerFactory.Trackers.FILE.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
        return td;
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testModifyError4() throws IOException {
        TableDescriptor td = this.createTableAndChangeToMigrationTracker();
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.Trackers.FILE.name()).setValue("hbase.store.file-tracker.migration.dst.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testModifyError5() throws IOException {
        TableDescriptor td = this.createTableAndChangeToMigrationTracker();
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).setValue("hbase.store.file-tracker.migration.dst.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testModifyError6() throws IOException {
        TableDescriptor td = this.createTableAndChangeToMigrationTracker();
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testModifyError7() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).build();
        UTIL.getAdmin().createTable(td);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"family1")).setConfiguration("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).build()).build();
        UTIL.getAdmin().modifyTable(newTd);
    }

    @Test(expected=IOException.class)
    public void testModifyError8() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).build();
        UTIL.getAdmin().createTable(td);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
    }

    @Test
    public void testModifyError9() throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)this.tableName.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"family")).build();
        UTIL.getAdmin().createTable(td);
        UTIL.getAdmin().disableTable(td.getTableName());
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).setValue("hbase.store.file-tracker.migration.dst.impl", StoreFileTrackerFactory.Trackers.FILE.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
        TableDescriptor newTd2 = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.FILE.name()).build();
        Assert.assertThrows(TableNotEnabledException.class, () -> UTIL.getAdmin().modifyTable(newTd2));
    }

    private String getStoreFileName(TableName table, byte[] family) {
        return ((HStoreFile)Iterables.getOnlyElement((Iterable)((HRegion)Iterables.getOnlyElement(UTIL.getMiniHBaseCluster().getRegions(table))).getStore(family).getStorefiles())).getPath().getName();
    }

    @Test
    public void testModify() throws IOException {
        TableName tn = this.tableName.getTableName();
        byte[] row = Bytes.toBytes((String)"row");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        UTIL.getAdmin().createTable(td);
        try (Table table = UTIL.getConnection().getTable(tn);){
            table.put(new Put(row).addColumn(family, qualifier, value));
        }
        UTIL.flush(tn);
        String fileName = this.getStoreFileName(tn, family);
        TableDescriptor newTd = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name()).setValue("hbase.store.file-tracker.migration.dst.impl", StoreFileTrackerFactory.Trackers.FILE.name()).build();
        UTIL.getAdmin().modifyTable(newTd);
        Assert.assertEquals((Object)fileName, (Object)this.getStoreFileName(tn, family));
        try (Table table = UTIL.getConnection().getTable(tn);){
            Assert.assertArrayEquals((byte[])value, (byte[])table.get(new Get(row)).getValue(family, qualifier));
        }
        TableDescriptor newTd2 = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.FILE.name()).build();
        UTIL.getAdmin().modifyTable(newTd2);
        Assert.assertEquals((Object)fileName, (Object)this.getStoreFileName(tn, family));
        try (Table table = UTIL.getConnection().getTable(tn);){
            Assert.assertArrayEquals((byte[])value, (byte[])table.get(new Get(row)).getValue(family, qualifier));
        }
    }
}

