/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;

public class BrokenRemoteAsyncFSWALProvider
extends AsyncFSWALProvider {
    protected AsyncFSWAL createWAL() throws IOException {
        return new BrokenRemoteAsyncFSWAL(CommonFSUtils.getWALFileSystem((Configuration)this.conf), this.abortable, CommonFSUtils.getWALRootDir((Configuration)this.conf), BrokenRemoteAsyncFSWALProvider.getWALDirectoryName((String)this.factory.getFactoryId()), BrokenRemoteAsyncFSWALProvider.getWALArchiveDirectoryName((Configuration)this.conf, (String)this.factory.getFactoryId()), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? ".meta" : null, null, null, this.eventLoopGroup, this.channelClass, this.factory.getExcludeDatanodeManager().getStreamSlowMonitor(this.providerId));
    }

    protected WAL createRemoteWAL(RegionInfo region, FileSystem remoteFs, Path remoteWALDir, String prefix, String suffix) throws IOException {
        return new BrokenRemoteAsyncFSWAL(CommonFSUtils.getWALFileSystem((Configuration)this.conf), this.abortable, CommonFSUtils.getWALRootDir((Configuration)this.conf), BrokenRemoteAsyncFSWALProvider.getWALDirectoryName((String)this.factory.getFactoryId()), BrokenRemoteAsyncFSWALProvider.getWALArchiveDirectoryName((Configuration)this.conf, (String)this.factory.getFactoryId()), this.conf, this.listeners, true, prefix, suffix, remoteFs, remoteWALDir, this.eventLoopGroup, this.channelClass, this.factory.getExcludeDatanodeManager().getStreamSlowMonitor(this.providerId));
    }

    static class BrokenRemoteAsyncFSWAL
    extends AsyncFSWAL {
        private volatile boolean localBroken;
        private volatile boolean remoteBroken;
        private CountDownLatch arrive;
        private CountDownLatch resume;

        public void setLocalBroken() {
            this.localBroken = true;
        }

        public void setRemoteBroken() {
            this.remoteBroken = true;
        }

        public void suspendLogRoll() {
            this.arrive = new CountDownLatch(1);
            this.resume = new CountDownLatch(1);
        }

        public void waitUntilArrive() throws InterruptedException {
            this.arrive.await();
        }

        public void resumeLogRoll() {
            this.resume.countDown();
        }

        public BrokenRemoteAsyncFSWAL(FileSystem fs, Abortable abortable, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, FileSystem remoteFs, Path remoteWALDir, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass, StreamSlowMonitor monitor) throws FailedLogCloseException, IOException {
            super(fs, abortable, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, remoteFs, remoteWALDir, eventLoopGroup, channelClass, monitor);
        }

        protected WALProvider.AsyncWriter createCombinedWriter(WALProvider.AsyncWriter localWriter, WALProvider.AsyncWriter remoteWriter) {
            return new MyCombinedAsyncWriter(localWriter, remoteWriter);
        }

        protected WALProvider.AsyncWriter createWriterInstance(FileSystem fs, Path path) throws IOException {
            if (this.arrive != null) {
                this.arrive.countDown();
                try {
                    this.resume.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.localBroken || this.remoteBroken) {
                throw new IOException("WAL broken");
            }
            return super.createWriterInstance(fs, path);
        }

        private final class MyCombinedAsyncWriter
        implements WALProvider.AsyncWriter {
            private final WALProvider.AsyncWriter localWriter;
            private final WALProvider.AsyncWriter remoteWriter;

            public MyCombinedAsyncWriter(WALProvider.AsyncWriter localWriter, WALProvider.AsyncWriter remoteWriter) {
                this.localWriter = localWriter;
                this.remoteWriter = remoteWriter;
            }

            public long getLength() {
                return this.localWriter.getLength();
            }

            public long getSyncedLength() {
                return this.localWriter.getSyncedLength();
            }

            public void close() throws IOException {
                Closeables.close((Closeable)this.localWriter, (boolean)true);
                Closeables.close((Closeable)this.remoteWriter, (boolean)true);
            }

            public CompletableFuture<Long> sync(boolean forceSync) {
                CompletableFuture remoteFuture;
                CompletableFuture localFuture;
                if (!BrokenRemoteAsyncFSWAL.this.localBroken) {
                    localFuture = this.localWriter.sync(forceSync);
                } else {
                    localFuture = new CompletableFuture();
                    localFuture.completeExceptionally(new IOException("Inject error"));
                }
                if (!BrokenRemoteAsyncFSWAL.this.remoteBroken) {
                    remoteFuture = this.remoteWriter.sync(forceSync);
                } else {
                    remoteFuture = new CompletableFuture();
                    remoteFuture.completeExceptionally(new IOException("Inject error"));
                }
                return CompletableFuture.allOf(localFuture, remoteFuture).thenApply(v -> localFuture.getNow(0L));
            }

            public void append(WAL.Entry entry) {
                if (!BrokenRemoteAsyncFSWAL.this.localBroken) {
                    this.localWriter.append(entry);
                }
                if (!BrokenRemoteAsyncFSWAL.this.remoteBroken) {
                    this.remoteWriter.append(entry);
                }
            }
        }
    }
}

