/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionServerList;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.replication.AssignReplicationQueuesProcedure;
import org.apache.hadoop.hbase.master.replication.RemovePeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestRemovePeerProcedureWaitForSCP
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRemovePeerProcedureWaitForSCP.class);
    private static final TableName tableName3 = TableName.valueOf((String)"test3");
    private static final String PEER_ID3 = "3";
    private static Table table3;
    private static volatile boolean EMPTY;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CONF1.setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        TestReplicationBase.setUpBeforeClass();
        TestRemovePeerProcedureWaitForSCP.createTable(tableName3);
        table3 = connection1.getTable(tableName3);
    }

    @Override
    public void setUpBase() throws Exception {
        super.setUpBase();
        this.addPeer(PEER_ID3, tableName3);
    }

    @Override
    public void tearDownBase() throws Exception {
        super.tearDownBase();
        this.removePeer(PEER_ID3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)table3, (boolean)true);
        TestReplicationBase.tearDownAfterClass();
    }

    @Test
    public void testWait() throws Exception {
        hbaseAdmin.disableReplicationPeer("2");
        hbaseAdmin.disableReplicationPeer(PEER_ID3);
        UTIL1.loadTable(htable1, famName);
        UTIL1.loadTable(table3, famName);
        EMPTY = true;
        UTIL1.getMiniHBaseCluster().stopRegionServer(0).join();
        UTIL1.getMiniHBaseCluster().startRegionServer();
        HMaster master = UTIL1.getMiniHBaseCluster().getMaster();
        UTIL1.waitFor(30000L, () -> master.getProcedures().stream().filter(p -> p instanceof AssignReplicationQueuesProcedure).anyMatch(p -> p.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT));
        hbaseAdmin.removeReplicationPeerAsync(PEER_ID3);
        UTIL1.waitFor(30000L, () -> master.getProcedures().stream().filter(p -> p instanceof RemovePeerProcedure).anyMatch(p -> ((RemovePeerProcedure)p).getCurrentStateId() == 8));
        Thread.sleep(5000L);
        Assert.assertEquals((long)8L, (long)((RemovePeerProcedure)master.getProcedures().stream().filter(p -> p instanceof RemovePeerProcedure).findFirst().get()).getCurrentStateId());
        EMPTY = false;
        UTIL1.waitFor(30000L, () -> master.getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).allMatch(Procedure::isSuccess));
        UTIL1.waitFor(30000L, () -> master.getProcedures().stream().filter(p -> p instanceof RemovePeerProcedure).allMatch(Procedure::isSuccess));
        MatcherAssert.assertThat((Object)master.getReplicationPeerManager().getQueueStorage().listAllQueueIds(PEER_ID3), (Matcher)Matchers.empty());
    }

    static {
        EMPTY = false;
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected ServerManager createServerManager(MasterServices master, RegionServerList storage) throws IOException {
            this.setupClusterConnection();
            return new ServerManagerForTest(master, storage);
        }
    }

    public static final class ServerManagerForTest
    extends ServerManager {
        public ServerManagerForTest(MasterServices master, RegionServerList storage) {
            super(master, storage);
        }

        public List<ServerName> getOnlineServersList() {
            if (EMPTY) {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!e.getClassName().equals(AssignReplicationQueuesProcedure.class.getName())) continue;
                    return Collections.emptyList();
                }
            }
            return super.getOnlineServersList();
        }
    }
}

