/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestReplicationEditsDroppedWithDeletedTableCFs {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationEditsDroppedWithDeletedTableCFs.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationEditsDroppedWithDeletedTableCFs.class);
    private static Configuration conf1 = HBaseConfiguration.create();
    private static Configuration conf2 = HBaseConfiguration.create();
    protected static HBaseTestingUtil utility1;
    protected static HBaseTestingUtil utility2;
    private static Admin admin1;
    private static Admin admin2;
    private static final TableName TABLE;
    private static final byte[] NORMAL_CF;
    private static final byte[] DROPPED_CF;
    private static final byte[] ROW;
    private static final byte[] QUALIFIER;
    private static final byte[] VALUE;
    private static final String PEER_ID = "1";
    private static final long SLEEP_TIME = 1000L;
    private static final int NB_RETRIES = 10;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1.setBoolean("hbase.replication.drop.on.deleted.columnfamily", true);
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("replication.source.nb.capacity", 1);
        utility1 = new HBaseTestingUtil(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        conf1 = utility1.getConfiguration();
        conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        utility2 = new HBaseTestingUtil(conf2);
        utility2.setZkCluster(miniZK);
        utility1.startMiniCluster(1);
        utility2.startMiniCluster(1);
        admin1 = utility1.getAdmin();
        admin2 = utility2.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            utility1.getAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(utility2.getClusterKey()).setReplicateAllUserTables(true).build();
        admin1.addReplicationPeer(PEER_ID, rpc);
        this.createTable();
    }

    @After
    public void tearDown() throws Exception {
        admin1.removeReplicationPeer(PEER_ID);
        admin1.disableTable(TABLE);
        admin1.deleteTable(TABLE);
        admin2.disableTable(TABLE);
        admin2.deleteTable(TABLE);
    }

    private void createTable() throws Exception {
        TableDescriptor desc = this.createTableDescriptor(NORMAL_CF, DROPPED_CF);
        admin1.createTable(desc);
        admin2.createTable(desc);
        utility1.waitUntilAllRegionsAssigned(desc.getTableName());
        utility2.waitUntilAllRegionsAssigned(desc.getTableName());
    }

    @Test
    public void testEditsDroppedWithDeleteCF() throws Exception {
        admin1.disableReplicationPeer(PEER_ID);
        try (Table table = utility1.getConnection().getTable(TABLE);){
            Put put = new Put(ROW);
            put.addColumn(DROPPED_CF, QUALIFIER, VALUE);
            table.put(put);
        }
        this.deleteCf(admin1);
        this.deleteCf(admin2);
        admin1.enableReplicationPeer(PEER_ID);
        this.verifyReplicationProceeded();
    }

    @Test
    public void testEditsBehindDeleteCFTiming() throws Exception {
        admin1.disableReplicationPeer(PEER_ID);
        try (Table table = utility1.getConnection().getTable(TABLE);){
            Put put = new Put(ROW);
            put.addColumn(DROPPED_CF, QUALIFIER, VALUE);
            table.put(put);
        }
        this.deleteCf(admin2);
        admin1.enableReplicationPeer(PEER_ID);
        this.verifyReplicationStuck();
        this.deleteCf(admin1);
        this.verifyReplicationProceeded();
    }

    private void verifyReplicationProceeded() throws Exception {
        try (Table table = utility1.getConnection().getTable(TABLE);){
            Put put = new Put(ROW);
            put.addColumn(NORMAL_CF, QUALIFIER, VALUE);
            table.put(put);
        }
        utility2.waitFor(10000L, () -> {
            try (Table peerTable = utility2.getConnection().getTable(TABLE);){
                Result result = peerTable.get(new Get(ROW).addColumn(NORMAL_CF, QUALIFIER));
                boolean bl = result != null && !result.isEmpty() && Bytes.equals((byte[])VALUE, (byte[])result.getValue(NORMAL_CF, QUALIFIER));
                return bl;
            }
        });
    }

    private void verifyReplicationStuck() throws Exception {
        try (Table table = utility1.getConnection().getTable(TABLE);){
            Put put = new Put(ROW);
            put.addColumn(NORMAL_CF, QUALIFIER, VALUE);
            table.put(put);
        }
        var2_2 = null;
        try (Table peerTable = utility2.getConnection().getTable(TABLE);){
            for (int i = 0; i < 10; ++i) {
                Result result = peerTable.get(new Get(ROW).addColumn(NORMAL_CF, QUALIFIER));
                if (result != null && !result.isEmpty()) {
                    Assert.fail((String)("Edit should have been stuck behind dropped tables, but value is " + Bytes.toString((byte[])result.getValue(NORMAL_CF, QUALIFIER))));
                    continue;
                }
                LOG.info("Row not replicated, let's wait a bit more...");
                Thread.sleep(1000L);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private TableDescriptor createTableDescriptor(byte[] ... cfs) {
        return TableDescriptorBuilder.newBuilder((TableName)TABLE).setColumnFamilies((Collection)Arrays.stream(cfs).map(cf -> ColumnFamilyDescriptorBuilder.newBuilder((byte[])cf).setScope(1).build()).collect(Collectors.toList())).build();
    }

    private void deleteCf(Admin admin) throws IOException {
        TableDescriptor desc = this.createTableDescriptor(new byte[][]{NORMAL_CF});
        admin.modifyTable(desc);
    }

    static {
        TABLE = TableName.valueOf((String)"table");
        NORMAL_CF = Bytes.toBytes((String)"normal_cf");
        DROPPED_CF = Bytes.toBytes((String)"dropped_cf");
        ROW = Bytes.toBytes((String)"row");
        QUALIFIER = Bytes.toBytes((String)"q");
        VALUE = Bytes.toBytes((String)"value");
    }
}

