/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationProcedureRetry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationProcedureRetry.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", MockHMaster.class, HMaster.class);
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDownAfterTest() throws IOException {
        for (ReplicationPeerDescription desc : UTIL.getAdmin().listReplicationPeers()) {
            UTIL.getAdmin().removeReplicationPeer(desc.getPeerId());
        }
    }

    private void doTest() throws IOException {
        Admin admin = UTIL.getAdmin();
        String peerId = "1";
        ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getZkCluster().getAddress().toString() + ":/hbase2").build();
        admin.addReplicationPeer(peerId, peerConfig, true);
        Assert.assertEquals((Object)peerConfig.getClusterKey(), (Object)admin.getReplicationPeerConfig(peerId).getClusterKey());
        ReplicationPeerConfig newPeerConfig = ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)peerConfig).setBandwidth(123456L).build();
        admin.updateReplicationPeerConfig(peerId, newPeerConfig);
        Assert.assertEquals((long)newPeerConfig.getBandwidth(), (long)admin.getReplicationPeerConfig(peerId).getBandwidth());
        admin.disableReplicationPeer(peerId);
        Assert.assertFalse((boolean)((ReplicationPeerDescription)admin.listReplicationPeers().get(0)).isEnabled());
        admin.enableReplicationPeer(peerId);
        Assert.assertTrue((boolean)((ReplicationPeerDescription)admin.listReplicationPeers().get(0)).isEnabled());
        admin.removeReplicationPeer(peerId);
        Assert.assertTrue((boolean)admin.listReplicationPeers().isEmpty());
        MockHMaster master = (MockHMaster)UTIL.getHBaseCluster().getMaster();
        Assert.assertTrue((boolean)master.addPeerCalled);
        Assert.assertTrue((boolean)master.removePeerCalled);
        Assert.assertTrue((boolean)master.updatePeerConfigCalled);
        Assert.assertTrue((boolean)master.enablePeerCalled);
        Assert.assertTrue((boolean)master.disablePeerCalled);
    }

    @Test
    public void testErrorBeforeUpdate() throws IOException, ReplicationException {
        ((MockHMaster)UTIL.getHBaseCluster().getMaster()).reset(true);
        this.doTest();
    }

    @Test
    public void testErrorAfterUpdate() throws IOException, ReplicationException {
        ((MockHMaster)UTIL.getHBaseCluster().getMaster()).reset(false);
        this.doTest();
    }

    public static final class MockHMaster
    extends HMaster {
        volatile boolean addPeerCalled;
        volatile boolean removePeerCalled;
        volatile boolean updatePeerConfigCalled;
        volatile boolean enablePeerCalled;
        volatile boolean disablePeerCalled;
        private ReplicationPeerManager manager;

        public MockHMaster(Configuration conf) throws IOException {
            super(conf);
        }

        private Object invokeWithError(InvocationOnMock invocation, boolean errorBeforeUpdate) throws Throwable {
            if (errorBeforeUpdate) {
                throw new ReplicationException("mock error before update");
            }
            invocation.callRealMethod();
            throw new ReplicationException("mock error after update");
        }

        public void reset(boolean errorBeforeUpdate) throws ReplicationException {
            this.addPeerCalled = false;
            this.removePeerCalled = false;
            this.updatePeerConfigCalled = false;
            this.enablePeerCalled = false;
            this.disablePeerCalled = false;
            ReplicationPeerManager m = super.getReplicationPeerManager();
            this.manager = (ReplicationPeerManager)Mockito.spy((Object)m);
            ((ReplicationPeerManager)Mockito.doAnswer(invocation -> {
                if (!this.addPeerCalled) {
                    this.addPeerCalled = true;
                    return this.invokeWithError(invocation, errorBeforeUpdate);
                }
                return invocation.callRealMethod();
            }).when((Object)this.manager)).addPeer(ArgumentMatchers.anyString(), (ReplicationPeerConfig)ArgumentMatchers.any(ReplicationPeerConfig.class), ArgumentMatchers.anyBoolean());
            ((ReplicationPeerManager)Mockito.doAnswer(invocation -> {
                if (!this.removePeerCalled) {
                    this.removePeerCalled = true;
                    return this.invokeWithError(invocation, errorBeforeUpdate);
                }
                return invocation.callRealMethod();
            }).when((Object)this.manager)).removePeer(ArgumentMatchers.anyString());
            ((ReplicationPeerManager)Mockito.doAnswer(invocation -> {
                if (!this.updatePeerConfigCalled) {
                    this.updatePeerConfigCalled = true;
                    return this.invokeWithError(invocation, errorBeforeUpdate);
                }
                return invocation.callRealMethod();
            }).when((Object)this.manager)).updatePeerConfig(ArgumentMatchers.anyString(), (ReplicationPeerConfig)ArgumentMatchers.any(ReplicationPeerConfig.class));
            ((ReplicationPeerManager)Mockito.doAnswer(invocation -> {
                if (!this.enablePeerCalled) {
                    this.enablePeerCalled = true;
                    return this.invokeWithError(invocation, errorBeforeUpdate);
                }
                return invocation.callRealMethod();
            }).when((Object)this.manager)).enablePeer(ArgumentMatchers.anyString());
            ((ReplicationPeerManager)Mockito.doAnswer(invocation -> {
                if (!this.disablePeerCalled) {
                    this.disablePeerCalled = true;
                    return this.invokeWithError(invocation, errorBeforeUpdate);
                }
                return invocation.callRealMethod();
            }).when((Object)this.manager)).disablePeer(ArgumentMatchers.anyString());
        }

        public ReplicationPeerManager getReplicationPeerManager() {
            return this.manager;
        }
    }
}

