/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.replication.TestReplicationSyncUpToolBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationSyncUpTool
extends TestReplicationSyncUpToolBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSyncUpTool.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationSyncUpTool.class);

    @Test
    public void testSyncUpTool() throws Exception {
        this.setupReplication();
        this.putAndReplicateRows();
        this.mimicSyncUpAfterDelete();
        this.mimicSyncUpAfterPut();
    }

    private void putAndReplicateRows() throws Exception {
        Put p;
        int i;
        LOG.debug("putAndReplicateRows");
        for (i = 0; i < 100; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("val" + i)));
            this.ht1Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9999"));
        p.addColumn(NO_REP_FAMILY, QUALIFIER, Bytes.toBytes((String)"val9999"));
        this.ht1Source.put(p);
        for (i = 0; i < 200; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("val" + i)));
            this.ht2Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9999"));
        p.addColumn(NO_REP_FAMILY, QUALIFIER, Bytes.toBytes((String)"val9999"));
        this.ht2Source.put(p);
        Thread.sleep(500L);
        int rowCountHt1Source = HBaseTestingUtil.countRows(this.ht1Source);
        for (int i2 = 0; i2 < 50; ++i2) {
            int rowCountHt1TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht1TargetAtPeer1);
            if (i2 == 49) {
                Assert.assertEquals((String)"t1_syncup has 101 rows on source, and 100 on slave1", (long)(rowCountHt1Source - 1), (long)rowCountHt1TargetAtPeer1);
            }
            if (rowCountHt1Source - 1 == rowCountHt1TargetAtPeer1) break;
            Thread.sleep(500L);
        }
        int rowCountHt2Source = HBaseTestingUtil.countRows(this.ht2Source);
        for (int i3 = 0; i3 < 50; ++i3) {
            int rowCountHt2TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht2TargetAtPeer1);
            if (i3 == 49) {
                Assert.assertEquals((String)"t2_syncup has 201 rows on source, and 200 on slave1", (long)(rowCountHt2Source - 1), (long)rowCountHt2TargetAtPeer1);
            }
            if (rowCountHt2Source - 1 == rowCountHt2TargetAtPeer1) break;
            Thread.sleep(500L);
        }
    }

    private void mimicSyncUpAfterDelete() throws Exception {
        Delete del;
        String rowKey;
        int i;
        LOG.debug("mimicSyncUpAfterDelete");
        this.shutDownTargetHBaseCluster();
        ArrayList<Delete> list = new ArrayList<Delete>();
        for (i = 0; i < 50; ++i) {
            rowKey = "row" + i;
            del = new Delete(Bytes.toBytes((String)rowKey));
            list.add(del);
        }
        this.ht1Source.delete(list);
        for (i = 0; i < 100; ++i) {
            rowKey = "row" + i;
            del = new Delete(Bytes.toBytes((String)rowKey));
            list.add(del);
        }
        this.ht2Source.delete(list);
        int rowCount_ht1Source = HBaseTestingUtil.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 51 rows on source, after remove 50 of the replicated colfam", (long)51L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = HBaseTestingUtil.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 101 rows on source, after remove 100 of the replicated colfam", (long)101L, (long)rowCount_ht2Source);
        List sourceRses = UTIL1.getHBaseCluster().getRegionServerThreads().stream().map(rst -> rst.getRegionServer().getServerName()).collect(Collectors.toList());
        this.shutDownSourceHBaseCluster();
        this.restartTargetHBaseCluster(1);
        Thread.sleep(500L);
        int rowCountHt1TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht1TargetAtPeer1);
        int rowCountHt2TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should still have 100 rows", (long)100L, (long)rowCountHt1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should still have 200 rows", (long)200L, (long)rowCountHt2TargetAtPeer1);
        this.syncUp(UTIL1);
        rowCountHt1TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht1TargetAtPeer1);
        rowCountHt2TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 50 rows", (long)50L, (long)rowCountHt1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 100 rows", (long)100L, (long)rowCountHt2TargetAtPeer1);
        Path rootDir = CommonFSUtils.getRootDir((Configuration)UTIL1.getConfiguration());
        Path syncUpInfoDir = new Path(rootDir, "ReplicationSyncUp");
        FileSystem fs = UTIL1.getTestFileSystem();
        for (ServerName sn : sourceRses) {
            Assert.assertTrue((boolean)fs.exists(new Path(syncUpInfoDir, sn.getServerName())));
        }
        Assert.assertTrue((boolean)fs.exists(new Path(syncUpInfoDir, "info")));
        Assert.assertEquals((long)(sourceRses.size() + 1), (long)fs.listStatus(syncUpInfoDir).length);
        this.restartSourceHBaseCluster(1);
        UTIL1.waitFor(60000L, () -> fs.listStatus(syncUpInfoDir).length == 0);
    }

    private void mimicSyncUpAfterPut() throws Exception {
        Put p;
        int i;
        LOG.debug("mimicSyncUpAfterPut");
        this.shutDownTargetHBaseCluster();
        for (i = 0; i < 100; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("val" + i)));
            this.ht1Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9998"));
        p.addColumn(NO_REP_FAMILY, QUALIFIER, Bytes.toBytes((String)"val9998"));
        this.ht1Source.put(p);
        for (i = 0; i < 200; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("val" + i)));
            this.ht2Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9998"));
        p.addColumn(NO_REP_FAMILY, QUALIFIER, Bytes.toBytes((String)"val9998"));
        this.ht2Source.put(p);
        int rowCount_ht1Source = HBaseTestingUtil.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 102 rows on source", (long)102L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = HBaseTestingUtil.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 202 rows on source", (long)202L, (long)rowCount_ht2Source);
        this.shutDownSourceHBaseCluster();
        this.restartTargetHBaseCluster(1);
        Thread.sleep(500L);
        int rowCountHt1TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht1TargetAtPeer1);
        int rowCountHt2TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should be NOT sync up and have 50 rows", (long)50L, (long)rowCountHt1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should be NOT sync up and have 100 rows", (long)100L, (long)rowCountHt2TargetAtPeer1);
        this.syncUp(UTIL1);
        rowCountHt1TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht1TargetAtPeer1);
        rowCountHt2TargetAtPeer1 = HBaseTestingUtil.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 100 rows", (long)100L, (long)rowCountHt1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 200 rows", (long)200L, (long)rowCountHt2TargetAtPeer1);
    }

    @Test
    public void testStartANewSyncUpToolAfterFailed() throws Exception {
        this.syncUp(UTIL1);
        Path rootDir = CommonFSUtils.getRootDir((Configuration)UTIL1.getConfiguration());
        Path syncUpInfoDir = new Path(rootDir, "ReplicationSyncUp");
        Path replicationInfoPath = new Path(syncUpInfoDir, "info");
        FileSystem fs = UTIL1.getTestFileSystem();
        Assert.assertTrue((boolean)fs.exists(replicationInfoPath));
        FileStatus fileStatus1 = fs.getFileStatus(replicationInfoPath);
        try {
            this.syncUp(UTIL1);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"e should be a FileAlreadyExistsException", (boolean)(e instanceof FileAlreadyExistsException));
        }
        FileStatus fileStatus2 = fs.getFileStatus(replicationInfoPath);
        Assert.assertEquals((long)fileStatus1.getModificationTime(), (long)fileStatus2.getModificationTime());
        this.syncUp(UTIL1, new String[]{"-f"});
        FileStatus fileStatus3 = fs.getFileStatus(replicationInfoPath);
        Assert.assertTrue((fileStatus3.getModificationTime() > fileStatus2.getModificationTime() ? 1 : 0) != 0);
    }
}

