/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSerialSyncReplication
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSerialSyncReplication.class);

    @Test
    public void test() throws Exception {
        UTIL1.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)UTIL1.getAdmin().getReplicationPeerConfig(PEER_ID)).setSerial(true).build());
        UTIL2.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)UTIL2.getAdmin().getReplicationPeerConfig(PEER_ID)).setSerial(true).build());
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        UTIL2.getAdmin().disableReplicationPeer(PEER_ID);
        this.writeAndVerifyReplication(UTIL1, UTIL2, 0, 100);
        MasterFileSystem mfs = UTIL2.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path remoteWALDir = ReplicationUtils.getPeerRemoteWALDir((Path)new Path(mfs.getWALRootDir(), "remoteWALs"), (String)PEER_ID);
        FileStatus[] remoteWALStatus = mfs.getWALFileSystem().listStatus(remoteWALDir);
        Assert.assertEquals((long)1L, (long)remoteWALStatus.length);
        Path remoteWAL = remoteWALStatus[0].getPath();
        MatcherAssert.assertThat((Object)remoteWAL.getName(), (Matcher)CoreMatchers.endsWith((String)".syncrep"));
        for (JVMClusterUtil.RegionServerThread t : UTIL1.getMiniHBaseCluster().getRegionServerThreads()) {
            LogRoller roller = t.getRegionServer().getWalRoller();
            roller.requestRollAll();
            roller.waitUntilWalRollFinished();
        }
        this.waitUntilDeleted(UTIL2, remoteWAL);
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        RegionInfo region = (RegionInfo)Iterables.getOnlyElement((Iterable)UTIL2.getAdmin().getRegions(TABLE_NAME));
        HRegionServer target = UTIL2.getOtherRegionServer(UTIL2.getRSForFirstRegionInTable(TABLE_NAME));
        UTIL2.getAdmin().move(region.getEncodedNameAsBytes(), target.getServerName());
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        UTIL2.getAdmin().enableReplicationPeer(PEER_ID);
        this.writeAndVerifyReplication(UTIL2, UTIL1, 100, 200);
    }
}

