/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.BrokenRemoteAsyncFSWALProvider;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationMoreLogsInLocalGiveUpSplitting
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationMoreLogsInLocalGiveUpSplitting.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSyncReplicationMoreLogsInLocalGiveUpSplitting.class);

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL1.getConfiguration().setClass("hbase.wal.provider", BrokenRemoteAsyncFSWALProvider.class, WALProvider.class);
        UTIL2.getConfiguration().setClass("hbase.wal.provider", BrokenRemoteAsyncFSWALProvider.class, WALProvider.class);
        SyncReplicationTestBase.setUp();
    }

    @Test
    public void testSplitLog() throws Exception {
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        UTIL2.getAdmin().disableReplicationPeer(PEER_ID);
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        try (Table table = UTIL1.getConnection().getTable(TABLE_NAME);){
            table.put(new Put(Bytes.toBytes((int)0)).addColumn(CF, CQ, Bytes.toBytes((int)0)));
        }
        HRegionServer rs = UTIL1.getRSForFirstRegionInTable(TABLE_NAME);
        BrokenRemoteAsyncFSWALProvider.BrokenRemoteAsyncFSWAL wal = (BrokenRemoteAsyncFSWALProvider.BrokenRemoteAsyncFSWAL)rs.getWalFactory().getWAL(RegionInfoBuilder.newBuilder((TableName)TABLE_NAME).build());
        wal.setRemoteBroken();
        wal.suspendLogRoll();
        try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL1.getConfiguration()).get();){
            AsyncTable table2 = conn.getTableBuilder(TABLE_NAME).setMaxAttempts(1).setWriteRpcTimeout(5L, TimeUnit.SECONDS).build();
            ExecutionException error = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
                Void cfr_ignored_0 = (Void)table2.put(new Put(Bytes.toBytes((int)1)).addColumn(CF, CQ, Bytes.toBytes((int)1))).get();
            });
            LOG.info("Expected error:", (Throwable)error);
        }
        wal.waitUntilArrive();
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        wal.resumeLogRoll();
        var4_7 = null;
        try (Table table = UTIL2.getConnection().getTable(TABLE_NAME);){
            Assert.assertEquals((long)0L, (long)Bytes.toInt((byte[])table.get(new Get(Bytes.toBytes((int)0))).getValue(CF, CQ)));
            Assert.assertFalse((boolean)table.exists(new Get(Bytes.toBytes((int)1))));
        }
        catch (Throwable table2) {
            var4_7 = table2;
            throw table2;
        }
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        table = UTIL1.getConnection().getTable(TABLE_NAME);
        var4_7 = null;
        try {
            Exception error = (Exception)Assert.assertThrows(Exception.class, () -> table.exists(new Get(Bytes.toBytes((int)0))));
            MatcherAssert.assertThat((Object)error, (Matcher)Matchers.either((Matcher)Matchers.instanceOf(DoNotRetryIOException.class)).or(Matchers.instanceOf(RetriesExhaustedException.class)));
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"STANDBY"));
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var4_7 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var4_7.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
        HRegion region = UTIL1.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        Assert.assertTrue((boolean)region.get(new Get(Bytes.toBytes((int)0))).isEmpty());
        UTIL2.getAdmin().enableReplicationPeer(PEER_ID);
        this.waitUntilReplicationDone(UTIL1, 1);
    }
}

