/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationRemoveRemoteWAL
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationRemoveRemoteWAL.class);

    @Test
    public void testRemoveRemoteWAL() throws Exception {
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        MasterFileSystem mfs = UTIL2.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path remoteWALDir = ReplicationUtils.getPeerRemoteWALDir((Path)new Path(mfs.getWALRootDir(), "remoteWALs"), (String)PEER_ID);
        FileStatus[] remoteWALStatus = mfs.getWALFileSystem().listStatus(remoteWALDir);
        Assert.assertEquals((long)1L, (long)remoteWALStatus.length);
        Path remoteWAL = remoteWALStatus[0].getPath();
        MatcherAssert.assertThat((Object)remoteWAL.getName(), (Matcher)CoreMatchers.endsWith((String)".syncrep"));
        this.writeAndVerifyReplication(UTIL1, UTIL2, 0, 100);
        HRegionServer rs = UTIL1.getRSForFirstRegionInTable(TABLE_NAME);
        rs.getWalRoller().requestRollAll();
        this.waitUntilDeleted(UTIL2, remoteWAL);
        remoteWALStatus = mfs.getWALFileSystem().listStatus(remoteWALDir);
        Assert.assertEquals((long)1L, (long)remoteWALStatus.length);
        remoteWAL = remoteWALStatus[0].getPath();
        MatcherAssert.assertThat((Object)remoteWAL.getName(), (Matcher)CoreMatchers.endsWith((String)".syncrep"));
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        this.write(UTIL1, 100, 200);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        Assert.assertTrue((boolean)mfs.getWALFileSystem().exists(remoteWAL));
        UTIL1.getAdmin().enableReplicationPeer(PEER_ID);
        this.waitUntilReplicationDone(UTIL2, 200);
        this.verifyThroughRegion(UTIL2, 100, 200);
        this.waitUntilDeleted(UTIL2, remoteWAL);
    }
}

