/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.regionserver.DumpReplicationQueues;
import org.apache.hadoop.hbase.replication.regionserver.TestReplicationSourceManager;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestDumpReplicationQueues {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDumpReplicationQueues.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static Configuration CONF;
    private static FileSystem FS;
    private Path root;
    private Path logDir;
    @Rule
    public final TestName name = new TestName();

    @Before
    public void setup() throws Exception {
        UTIL.startMiniCluster(3);
        CONF = UTIL.getConfiguration();
        TableName tableName = TableName.valueOf((String)("replication_" + this.name.getMethodName()));
        UTIL.getAdmin().createTable(ReplicationStorageFactory.createReplicationQueueTableDescriptor((TableName)tableName));
        CONF.set("hbase.replication.queue.table.name", tableName.getNameAsString());
        FS = FileSystem.get((Configuration)CONF);
        this.root = UTIL.getDataTestDirOnTestFS("hbase");
        this.logDir = new Path(this.root, "WALs");
        FS.mkdirs(this.logDir);
        CommonFSUtils.setRootDir((Configuration)CONF, (Path)this.root);
        CommonFSUtils.setWALRootDir((Configuration)CONF, (Path)this.root);
    }

    @Test
    public void testDumpReplication() throws Exception {
        String peerId = "1";
        String serverNameStr = "rs1,12345,123";
        this.addPeer(peerId, "hbase");
        ServerName serverName = ServerName.valueOf((String)serverNameStr);
        String walName = "rs1%2C12345%2C123.10";
        Path walPath = new Path(this.logDir, serverNameStr + "/" + walName);
        FS.createNewFile(walPath);
        ReplicationQueueId queueId = new ReplicationQueueId(serverName, peerId);
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((Connection)UTIL.getConnection(), (Configuration)CONF);
        queueStorage.setOffset(queueId, "wal-group", new ReplicationGroupOffset(FS.listStatus(walPath)[0].getPath().toString(), 123L), Collections.emptyMap());
        DumpReplicationQueues dumpQueues = new DumpReplicationQueues();
        HashSet<String> peerIds = new HashSet<String>();
        peerIds.add(peerId);
        ArrayList<String> wals = new ArrayList<String>();
        wals.add("rs1%2C12345%2C123.12");
        wals.add("rs1%2C12345%2C123.15");
        wals.add("rs1%2C12345%2C123.11");
        for (String wal : wals) {
            Path wPath = new Path(this.logDir, serverNameStr + "/" + wal);
            FS.createNewFile(wPath);
        }
        String dump = dumpQueues.dumpQueues(UTIL.getConnection(), peerIds, false, CONF);
        Assert.assertTrue((dump.indexOf("Queue id: 1-rs1,12345,123") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump.indexOf("Number of WALs in replication queue: 4") > 0 ? 1 : 0) != 0);
        String[] parsedDump = dump.split("Replication position for");
        Assert.assertTrue((String)("First wal should be rs1%2C12345%2C123.10: 123, but got: " + parsedDump[1]), (parsedDump[1].indexOf("rs1%2C12345%2C123.10: 123") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Second wal should be rs1%2C12345%2C123.11: 0, but got: " + parsedDump[2]), (parsedDump[2].indexOf("rs1%2C12345%2C123.11: 0 (not started or nothing to replicate)") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Third wal should be rs1%2C12345%2C123.12: 0, but got: " + parsedDump[3]), (parsedDump[3].indexOf("rs1%2C12345%2C123.12: 0 (not started or nothing to replicate)") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Fourth wal should be rs1%2C12345%2C123.15: 0, but got: " + parsedDump[4]), (parsedDump[4].indexOf("rs1%2C12345%2C123.15: 0 (not started or nothing to replicate)") >= 0 ? 1 : 0) != 0);
        Path file1 = new Path("testHFile1");
        Path file2 = new Path("testHFile2");
        ArrayList<Pair> files = new ArrayList<Pair>(1);
        files.add(new Pair(null, (Object)file1));
        files.add(new Pair(null, (Object)file2));
        queueStorage.addHFileRefs(peerId, files);
        String dump2 = dumpQueues.dumpReplicationViaTable(UTIL.getConnection(), CONF);
        Assert.assertTrue((dump2.indexOf("peers/1/peer-state: ENABLED") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump2.indexOf("rs1,12345,123/rs1%2C12345%2C123.10: 123") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump2.indexOf("hfile-refs/1/testHFile1,testHFile2") >= 0 ? 1 : 0) != 0);
    }

    private void addPeer(String peerId, String clusterKey) throws IOException {
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getZkCluster().getAddress().toString() + ":/" + clusterKey).setReplicationEndpointImpl(TestReplicationSourceManager.ReplicationEndpointForTest.class.getName());
        UTIL.getAdmin().addReplicationPeer(peerId, builder.build(), true);
    }

    @After
    public void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    static {
        FS = null;
    }
}

