/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALActionListener;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestReplicationWALEdits {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationWALEdits.class);
    private static final Configuration CONF = HBaseConfiguration.create();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final byte[] F1 = Bytes.toBytes((String)"f1");
    private static final byte[] F2 = Bytes.toBytes((String)"f2");
    private static final RegionInfo RI = RegionInfoBuilder.newBuilder((TableName)TABLE_NAME).build();

    @Test
    public void testCompactionWALEdits() throws Exception {
        TableName tableName = TableName.valueOf((String)"testCompactionWALEdits");
        WALProtos.CompactionDescriptor compactionDescriptor = WALProtos.CompactionDescriptor.getDefaultInstance();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).build();
        WALEdit edit = WALEdit.createCompaction((RegionInfo)hri, (WALProtos.CompactionDescriptor)compactionDescriptor);
        ReplicationSourceWALActionListener.scopeWALEdits((WALKey)new WALKeyImpl(), (WALEdit)edit, (Configuration)CONF);
    }

    private WALEdit getBulkLoadWALEdit(NavigableMap<byte[], Integer> scope) {
        HashMap storeFiles = new HashMap(1);
        HashMap<String, Long> storeFilesSize = new HashMap<String, Long>(1);
        ArrayList<Path> p = new ArrayList<Path>(1);
        Path hfilePath1 = new Path(Bytes.toString((byte[])F1));
        p.add(hfilePath1);
        storeFilesSize.put(hfilePath1.getName(), 0L);
        storeFiles.put(F1, p);
        scope.put(F1, 1);
        p = new ArrayList(1);
        Path hfilePath2 = new Path(Bytes.toString((byte[])F2));
        p.add(hfilePath2);
        storeFilesSize.put(hfilePath2.getName(), 0L);
        storeFiles.put(F2, p);
        WALProtos.BulkLoadDescriptor desc = ProtobufUtil.toBulkLoadDescriptor((TableName)RI.getTable(), (ByteString)UnsafeByteOperations.unsafeWrap((byte[])RI.getEncodedNameAsBytes()), storeFiles, storeFilesSize, (long)1L);
        WALEdit logEdit = WALEdit.createBulkLoadEvent((RegionInfo)RI, (WALProtos.BulkLoadDescriptor)desc);
        return logEdit;
    }

    @Test
    public void testBulkLoadWALEditsWithoutBulkLoadReplicationEnabled() throws Exception {
        TreeMap<byte[], Integer> scope = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        WALEdit logEdit = this.getBulkLoadWALEdit(scope);
        WALKeyImpl logKey = new WALKeyImpl(scope);
        ReplicationSourceWALActionListener.scopeWALEdits((WALKey)logKey, (WALEdit)logEdit, (Configuration)CONF);
        Assert.assertNull((String)"No bulk load entries scope should be added if bulk load replication is disabled.", (Object)logKey.getReplicationScopes());
    }

    @Test
    public void testBulkLoadWALEdits() throws Exception {
        TreeMap<byte[], Integer> scope = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        WALEdit logEdit = this.getBulkLoadWALEdit(scope);
        WALKeyImpl logKey = new WALKeyImpl(scope);
        Configuration bulkLoadConf = HBaseConfiguration.create((Configuration)CONF);
        bulkLoadConf.setBoolean("hbase.replication.bulkload.enabled", true);
        ReplicationSourceWALActionListener.scopeWALEdits((WALKey)logKey, (WALEdit)logEdit, (Configuration)bulkLoadConf);
        NavigableMap scopes = logKey.getReplicationScopes();
        Assert.assertTrue((String)"This family scope is set to global, should be part of replication key scopes.", (boolean)scopes.containsKey(F1));
        Assert.assertFalse((String)"This family scope is set to local, should not be part of replication key scopes", (boolean)scopes.containsKey(F2));
    }
}

