/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RSGroupTests.class, SmallTests.class})
public class TestRSGroupMappingScript {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupMappingScript.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupMappingScript.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private File script;

    @BeforeClass
    public static void setupScript() throws Exception {
        String currentDir = new File("").getAbsolutePath();
        UTIL.getConfiguration().set("hbase.rsgroup.table.mapping.script", currentDir + "/rsgroup_table_mapping.sh");
    }

    @Before
    public void setup() throws Exception {
        this.script = new File(UTIL.getConfiguration().get("hbase.rsgroup.table.mapping.script"));
        if (!this.script.createNewFile()) {
            throw new IOException("Can't create script");
        }
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(this.script));){
            pw.println("#!/bin/bash");
            pw.println("namespace=$1");
            pw.println("tablename=$2");
            pw.println("if [[ $namespace == test ]]; then");
            pw.println("  echo test");
            pw.println("elif [[ $tablename == *foo* ]]; then");
            pw.println("  echo other");
            pw.println("else");
            pw.println("  echo default");
            pw.println("fi");
            pw.flush();
        }
        boolean executable = this.script.setExecutable(true);
        LOG.info("Created " + this.script + ", executable=" + executable);
        this.verifyScriptContent(this.script);
    }

    private void verifyScriptContent(File file) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            LOG.info(line);
        }
    }

    @Test
    public void testScript() throws Exception {
        RSGroupInfoManagerImpl.RSGroupMappingScript script = new RSGroupInfoManagerImpl.RSGroupMappingScript(UTIL.getConfiguration());
        TableName testNamespace = TableName.valueOf((String)"test", (String)"should_be_in_test");
        String rsgroup = script.getRSGroup(testNamespace.getNamespaceAsString(), testNamespace.getQualifierAsString());
        Assert.assertEquals((Object)"test", (Object)rsgroup);
        TableName otherName = TableName.valueOf((String)"whatever", (String)"oh_foo_should_be_in_other");
        rsgroup = script.getRSGroup(otherName.getNamespaceAsString(), otherName.getQualifierAsString());
        Assert.assertEquals((Object)"other", (Object)rsgroup);
        TableName defaultName = TableName.valueOf((String)"nono", (String)"should_be_in_default");
        rsgroup = script.getRSGroup(defaultName.getNamespaceAsString(), defaultName.getQualifierAsString());
        Assert.assertEquals((Object)"default", (Object)rsgroup);
    }

    @After
    public void teardown() throws Exception {
        if (this.script.exists()) {
            this.script.delete();
        }
    }
}

