/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RSGroupTests.class, MediumTests.class})
public class TestRSGroupsBalance
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsBalance.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsBalance.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsBalance.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsBalance.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testGroupBalance() throws Exception {
        String methodName = this.name.getMethodName();
        LOG.info(methodName);
        String newGroupName = this.getGroupName(methodName);
        final TableName tableName = TableName.valueOf((String)"Group_ns", (String)methodName);
        ServerName first = this.setupBalanceTest(newGroupName, tableName);
        ADMIN.balancerSwitch(true, true);
        ADMIN.balanceRSGroup("default");
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
        ADMIN.balancerSwitch(false, true);
        Assert.assertFalse((boolean)ADMIN.balanceRSGroup(newGroupName).isBalancerRan());
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
        ADMIN.balancerSwitch(true, true);
        ADMIN.balanceRSGroup(newGroupName);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (List<String> regions : TestRSGroupsBalance.this.getTableServerRegionMap().get(tableName).values()) {
                    if (2 == regions.size()) continue;
                    return false;
                }
                return true;
            }
        });
        ADMIN.balancerSwitch(false, true);
    }

    @Test
    public void testGroupDryRunBalance() throws Exception {
        String methodName = this.name.getMethodName();
        LOG.info(methodName);
        String newGroupName = this.getGroupName(methodName);
        TableName tableName = TableName.valueOf((String)"Group_ns", (String)methodName);
        ServerName first = this.setupBalanceTest(newGroupName, tableName);
        ADMIN.balancerSwitch(true, true);
        BalanceResponse response = ADMIN.balanceRSGroup(newGroupName, BalanceRequest.newBuilder().setDryRun(true).build());
        Assert.assertTrue((boolean)response.isBalancerRan());
        Assert.assertTrue((response.getMovesCalculated() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)response.getMovesExecuted());
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
    }

    private ServerName setupBalanceTest(String newGroupName, final TableName tableName) throws Exception {
        this.addGroup(newGroupName, 3);
        ADMIN.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", newGroupName).build());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        ADMIN.createTable(desc, startKey, endKey, 6);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsBalance.this.getTableRegionMap().get(tableName);
                if (regions == null) {
                    return false;
                }
                return regions.size() >= 6;
            }
        });
        Map<ServerName, List<String>> assignMap = this.getTableServerRegionMap().get(tableName);
        final ServerName first = assignMap.entrySet().iterator().next().getKey();
        for (RegionInfo region : ADMIN.getRegions(tableName)) {
            if (assignMap.get(first).contains(region.getRegionNameAsString())) continue;
            ADMIN.move(region.getEncodedNameAsBytes(), first);
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map<ServerName, List<String>> map = TestRSGroupsBalance.this.getTableServerRegionMap().get(tableName);
                if (map == null) {
                    return true;
                }
                List<String> regions = map.get(first);
                if (regions == null) {
                    return true;
                }
                return regions.size() >= 6;
            }
        });
        return first;
    }

    @Test
    public void testMisplacedRegions() throws Exception {
        String namespace = "Group_" + TestRSGroupsBalance.getNameWithoutIndex(this.name.getMethodName());
        TEST_UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)namespace).build());
        TableName tableName = TableName.valueOf((String)namespace, (String)("Group_" + TestRSGroupsBalance.getNameWithoutIndex(this.name.getMethodName())));
        final RSGroupInfo rsGroupInfo = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        TEST_UTIL.createMultiRegionTable(tableName, new byte[]{102}, 15);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        TEST_UTIL.getAdmin().modifyNamespace(NamespaceDescriptor.create((String)namespace).addConfiguration("hbase.rsgroup.name", rsGroupInfo.getName()).build());
        ADMIN.balancerSwitch(true, true);
        Assert.assertTrue((boolean)ADMIN.balanceRSGroup(rsGroupInfo.getName()).isBalancerRan());
        ADMIN.balancerSwitch(false, true);
        Assert.assertTrue((boolean)TestRSGroupsBalance.OBSERVER.preBalanceRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsBalance.OBSERVER.postBalanceRSGroupCalled);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ServerName serverName = ServerName.valueOf((String)((Address)rsGroupInfo.getServers().iterator().next()).toString(), (long)1L);
                return TestRSGroupsBase.ADMIN.getConnection().getAdmin().getRegions(serverName).size() == 15;
            }
        });
    }

    @Test
    public void testGetRSGroupAssignmentsByTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(tableName, HConstants.CATALOG_FAMILY, 10);
        TableName disableTableName = TableName.valueOf((String)"testDisableTable");
        TEST_UTIL.createMultiRegionTable(disableTableName, HConstants.CATALOG_FAMILY, 10);
        TEST_UTIL.getAdmin().disableTable(disableTableName);
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        RSGroupInfoManagerImpl gm = (RSGroupInfoManagerImpl)master.getRSGroupInfoManager();
        Map assignments = gm.getRSGroupAssignmentsByTable(master.getTableStateManager(), "default");
        Assert.assertFalse((boolean)assignments.containsKey(disableTableName));
        Assert.assertTrue((boolean)assignments.containsKey(tableName));
    }
}

