/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.AuthenticationProviderSelector;
import org.apache.hadoop.hbase.security.provider.BuiltInProviderSelector;
import org.apache.hadoop.hbase.security.provider.SaslAuthMethod;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractTestSecureIPC {
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    protected static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    protected static MiniKdc KDC;
    protected static String HOST;
    protected static String PRINCIPAL;
    protected String krbKeytab;
    protected String krbPrincipal;
    protected UserGroupInformation ugi;
    protected Configuration clientConf;
    protected Configuration serverConf;

    protected static void initKDCAndConf() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        HBaseKerberosUtils.setPrincipalForTesting((String)(PRINCIPAL + "@" + KDC.getRealm()));
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.socket.timeout.read", 2000);
        TEST_UTIL.getConfiguration().setInt("hbase.security.relogin.maxretries", 1);
    }

    protected static void stopKDC() throws InterruptedException {
        if (KDC != null) {
            KDC.stop();
        }
    }

    protected final void setUpPrincipalAndConf() throws Exception {
        this.krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        this.krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        this.ugi = HBaseKerberosUtils.loginKerberosPrincipal((String)this.krbKeytab, (String)this.krbPrincipal);
        this.clientConf = new Configuration(TEST_UTIL.getConfiguration());
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)this.clientConf);
        this.serverConf = new Configuration(TEST_UTIL.getConfiguration());
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)this.serverConf);
    }

    @Test
    public void testRpcCallWithEnabledKerberosSaslAuth() throws Exception {
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi2, (Object)this.ugi);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)this.ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)this.krbPrincipal, (Object)this.ugi.getUserName());
        this.callRpcService(User.create((UserGroupInformation)ugi2));
    }

    @Test
    public void testRpcCallWithEnabledKerberosSaslAuthCanonicalHostname() throws Exception {
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi2, (Object)this.ugi);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)this.ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)this.krbPrincipal, (Object)this.ugi.getUserName());
        AbstractTestSecureIPC.enableCanonicalHostnameTesting(this.clientConf, "localhost");
        this.clientConf.setBoolean("hbase.unsafe.client.kerberos.hostname.disable.reversedns", false);
        this.clientConf.set("hbase.regionserver.kerberos.principal", "hbase/_HOST@" + KDC.getRealm());
        this.callRpcService(User.create((UserGroupInformation)ugi2));
    }

    @Test
    public void testRpcCallWithEnabledKerberosSaslAuthNoCanonicalHostname() throws Exception {
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi2, (Object)this.ugi);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)this.ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)this.krbPrincipal, (Object)this.ugi.getUserName());
        AbstractTestSecureIPC.enableCanonicalHostnameTesting(this.clientConf, "127.0.0.1");
        this.clientConf.setBoolean("hbase.unsafe.client.kerberos.hostname.disable.reversedns", true);
        this.clientConf.set("hbase.regionserver.kerberos.principal", "hbase/_HOST@" + KDC.getRealm());
        this.callRpcService(User.create((UserGroupInformation)ugi2));
    }

    private static void enableCanonicalHostnameTesting(Configuration conf, String canonicalHostname) {
        conf.setClass("hbase.client.sasl.provider.class", CanonicalHostnameTestingAuthenticationProviderSelector.class, AuthenticationProviderSelector.class);
        conf.set("CanonicalHostnameTestingAuthenticationProviderSelector.canonicalHostName", canonicalHostname);
    }

    @Test
    public void testRpcFallbackToSimpleAuth() throws Exception {
        String clientUsername = "testuser";
        UserGroupInformation clientUgi = UserGroupInformation.createUserForTesting((String)clientUsername, (String[])new String[]{clientUsername});
        Assert.assertNotSame((Object)this.ugi, (Object)clientUgi);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE, (Object)clientUgi.getAuthenticationMethod());
        Assert.assertEquals((Object)clientUsername, (Object)clientUgi.getUserName());
        this.clientConf.set("hbase.security.authentication", "simple");
        this.serverConf.setBoolean("hbase.ipc.server.fallback-to-simple-auth-allowed", true);
        this.callRpcService(User.create((UserGroupInformation)clientUgi));
    }

    private void setRpcProtection(String clientProtection, String serverProtection) {
        this.clientConf.set("hbase.rpc.protection", clientProtection);
        this.serverConf.set("hbase.rpc.protection", serverProtection);
    }

    @Test
    public void testSaslWithCommonQop() throws Exception {
        this.setRpcProtection("privacy,authentication", "authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setRpcProtection("authentication", "privacy,authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setRpcProtection("integrity,authentication", "privacy,authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setRpcProtection("integrity,authentication", "integrity,authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setRpcProtection("privacy,authentication", "privacy,authentication");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
    }

    @Test
    public void testSaslNoCommonQop() throws Exception {
        this.setRpcProtection("integrity", "privacy");
        SaslException se = (SaslException)Assert.assertThrows(SaslException.class, () -> this.callRpcService(User.create((UserGroupInformation)this.ugi)));
        Assert.assertEquals((Object)"No common protection layer between client and server", (Object)se.getMessage());
    }

    @Test
    public void testSaslWithCryptoAES() throws Exception {
        this.setRpcProtection("privacy", "privacy");
        this.setCryptoAES("true", "true");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
    }

    @Test
    public void testDifferentConfWithCryptoAES() throws Exception {
        this.setRpcProtection("privacy", "privacy");
        this.setCryptoAES("false", "true");
        this.callRpcService(User.create((UserGroupInformation)this.ugi));
        this.setCryptoAES("true", "false");
        try {
            this.callRpcService(User.create((UserGroupInformation)this.ugi));
            Assert.fail((String)"The exception should be thrown out for the rpc timeout.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCryptoAES(String clientCryptoAES, String serverCryptoAES) {
        this.clientConf.set("hbase.rpc.crypto.encryption.aes.enabled", clientCryptoAES);
        this.serverConf.set("hbase.rpc.crypto.encryption.aes.enabled", serverCryptoAES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callRpcService(User clientUser) throws Exception {
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipal()).thenReturn((Object)"hbase.regionserver.kerberos.principal");
        SecurityInfo.addInfo((String)"TestProtobufRpcProto", (SecurityInfo)securityInfoMock);
        InetSocketAddress isa = new InetSocketAddress(HOST, 0);
        RpcServer rpcServer = RpcServerFactory.createRpcServer(null, (String)"AbstractTestSecureIPC", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), (InetSocketAddress)isa, (Configuration)this.serverConf, (RpcScheduler)new FifoRpcScheduler(this.serverConf, 1));
        rpcServer.start();
        try (RpcClient rpcClient = RpcClientFactory.createClient((Configuration)this.clientConf, (String)HConstants.DEFAULT_CLUSTER_ID.toString());){
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(rpcClient, rpcServer.getListenerAddress(), clientUser);
            TestThread th1 = new TestThread(stub);
            final Throwable[] exception = new Throwable[1];
            Collections.synchronizedList(new ArrayList());
            Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread th, Throwable ex) {
                    exception[0] = ex;
                }
            };
            th1.setUncaughtExceptionHandler(exceptionHandler);
            th1.start();
            th1.join();
            if (exception[0] != null) {
                while (exception[0].getCause() != null) {
                    exception[0] = exception[0].getCause();
                }
                throw (Exception)exception[0];
            }
        }
        finally {
            rpcServer.stop();
        }
    }

    static {
        HOST = "localhost";
    }

    public static class TestThread
    extends Thread {
        private final TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub;

        public TestThread(TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub) {
            this.stub = stub;
        }

        @Override
        public void run() {
            try {
                int[] messageSize = new int[]{100, 1000, 10000};
                for (int i = 0; i < messageSize.length; ++i) {
                    String input = RandomStringUtils.random((int)messageSize[i]);
                    String result = this.stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage(input).build()).getMessage();
                    Assert.assertEquals((Object)input, (Object)result);
                }
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class CanonicalHostnameTestingAuthenticationProviderSelector
    extends BuiltInProviderSelector {
        private static final String CANONICAL_HOST_NAME_KEY = "CanonicalHostnameTestingAuthenticationProviderSelector.canonicalHostName";

        public Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>> selectProvider(String clusterId, User user) {
            Pair pair = super.selectProvider(clusterId, user);
            pair.setFirst((Object)this.createCanonicalHostNameTestingProvider((SaslClientAuthenticationProvider)pair.getFirst()));
            return pair;
        }

        SaslClientAuthenticationProvider createCanonicalHostNameTestingProvider(final SaslClientAuthenticationProvider delegate) {
            return new SaslClientAuthenticationProvider(){

                public SaslClient createClient(Configuration conf, InetAddress serverAddr, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
                    String s = conf.get(CanonicalHostnameTestingAuthenticationProviderSelector.CANONICAL_HOST_NAME_KEY);
                    if (s != null) {
                        try {
                            Field canonicalHostName = InetAddress.class.getDeclaredField("canonicalHostName");
                            canonicalHostName.setAccessible(true);
                            canonicalHostName.set(serverAddr, s);
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return delegate.createClient(conf, serverAddr, securityInfo, token, fallbackAllowed, saslProps);
                }

                public RPCProtos.UserInformation getUserInfo(User user) {
                    return delegate.getUserInfo(user);
                }

                public UserGroupInformation getRealUser(User ugi) {
                    return delegate.getRealUser(ugi);
                }

                public boolean canRetry() {
                    return delegate.canRetry();
                }

                public void relogin() throws IOException {
                    delegate.relogin();
                }

                public SaslAuthMethod getSaslAuthMethod() {
                    return delegate.getSaslAuthMethod();
                }

                public String getTokenKind() {
                    return delegate.getTokenKind();
                }
            };
        }
    }
}

