/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContext;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContextProvider;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.AbstractTestSecureIPC;
import org.apache.hadoop.hbase.security.TestNettyTlsIPC;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, LargeTests.class})
public class TestSaslTlsIPC
extends AbstractTestSecureIPC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSaslTlsIPC.class);
    private static X509TestContextProvider PROVIDER;
    @Parameterized.Parameter(value=0)
    public X509KeyType caKeyType;
    @Parameterized.Parameter(value=1)
    public X509KeyType certKeyType;
    @Parameterized.Parameter(value=2)
    public char[] keyPassword;
    @Parameterized.Parameter(value=3)
    public boolean acceptPlainText;
    @Parameterized.Parameter(value=4)
    public boolean clientTlsEnabled;
    private X509TestContext x509TestContext;

    @Parameterized.Parameters(name="{index}: caKeyType={0}, certKeyType={1}, keyPassword={2}, acceptPlainText={3}, clientTlsEnabled={4}")
    public static List<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (char[] keyPassword : new char[][]{"".toCharArray(), "pa$$w0rd".toCharArray()}) {
                    params.add(new Object[]{caKeyType, certKeyType, keyPassword, false, true});
                    params.add(new Object[]{caKeyType, certKeyType, keyPassword, true, true});
                    params.add(new Object[]{caKeyType, certKeyType, keyPassword, true, false});
                }
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        File dir = new File(TEST_UTIL.getDataTestDir(TestNettyTlsIPC.class.getSimpleName()).toString()).getCanonicalFile();
        FileUtils.forceMkdir((File)dir);
        TestSaslTlsIPC.initKDCAndConf();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.server.netty.tls.enabled", true);
        conf.setClass("hbase.rpc.client.impl", NettyRpcClient.class, RpcClient.class);
        conf.setClass("hbase.rpc.server.impl", NettyRpcServer.class, RpcServer.class);
        PROVIDER = new X509TestContextProvider(conf, dir);
    }

    @AfterClass
    public static void tearDownAfterClass() throws InterruptedException {
        TestSaslTlsIPC.stopKDC();
        Security.removeProvider("BC");
        TEST_UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws Exception {
        this.x509TestContext = PROVIDER.get(this.caKeyType, this.certKeyType, this.keyPassword);
        this.x509TestContext.setConfigurations(KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.server.netty.tls.supportplaintext", this.acceptPlainText);
        conf.setBoolean("hbase.client.netty.tls.enabled", this.clientTlsEnabled);
        this.setUpPrincipalAndConf();
    }

    @After
    public void tearDown() {
        this.x509TestContext.clearConfigurations();
        this.x509TestContext.getConf().unset("hbase.rpc.tls.ocsp");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.clr");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.protocol");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
    }
}

