/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsWithDeletesTestBase;
import org.apache.hadoop.hbase.shaded.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestVisibilityLabelsWithDeletes
extends VisibilityLabelsWithDeletesTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVisibilityLabelsWithDeletes.class);

    @Override
    protected Table createTable(byte[] fam) throws IOException {
        TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        TEST_UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])fam)).build());
        return TEST_UTIL.getConnection().getTable(tableName);
    }

    private TableName createTable() throws IOException {
        return this.createTable(-1);
    }

    private TableName createTable(int maxVersions) throws IOException {
        TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        this.createTable(tableName, maxVersions);
        return tableName;
    }

    private void createTable(TableName tableName, int maxVersions) throws IOException {
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam);
        if (maxVersions > 0) {
            builder.setMaxVersions(maxVersions);
        }
        TEST_UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(builder.build()).build());
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithMultipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d1 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d1.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                        d1.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d1);
                        Delete d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d2.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d2.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d2);
                        Delete d3 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d3.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d3.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d3);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnsNoMatchVisExpWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                        d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET"));
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                        d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamilyWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d1 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d1.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                        d1.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d1);
                        Delete d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d2.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d2.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d2);
                        Delete d3 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d3.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d3.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d3);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnsWithoutAndWithVisibilityLabels() throws Exception {
        final TableName tableName = this.createTable();
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            Delete d = new Delete(row1);
            d.addColumns(fam, qual, Long.MAX_VALUE);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)1L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            d.addColumns(fam, qual, Long.MAX_VALUE);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)0L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testDeleteColumnsWithAndWithoutVisibilityLabels() throws Exception {
        final TableName tableName = this.createTable();
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            Delete d = new Delete(row1);
            d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            d.addColumns(fam, qual, Long.MAX_VALUE);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)0L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.addColumns(fam, qual, Long.MAX_VALUE);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)0L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testDeleteFamiliesWithoutAndWithVisibilityLabels() throws Exception {
        final TableName tableName = this.createTable();
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            Delete d = new Delete(row1);
            d.addFamily(fam);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)1L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            d.addFamily(fam);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)0L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testDeleteFamiliesWithAndWithoutVisibilityLabels() throws Exception {
        final TableName tableName = this.createTable();
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            Delete d = new Delete(row1);
            d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            d.addFamily(fam);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)0L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.addFamily(fam);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)0L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testDeletesWithoutAndWithVisibilityLabels() throws Exception {
        final TableName tableName = this.createTable();
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row1);
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            Delete d = new Delete(row1);
            d.addColumn(fam, qual);
            table.delete(d);
            PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)1L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
            d = new Delete(row1);
            d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            d.addColumn(fam, qual);
            table.delete(d);
            scanAction = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Scan s = new Scan();
                        ResultScanner scanner = table.getScanner(s);
                        Result[] next = scanner.next(3);
                        Assert.assertEquals((long)0L, (long)next.length);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)scanAction);
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamilyWithPutsReAppearing() throws Exception {
        final TableName tableName = this.createTable(5);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("SECRET"));
            table.put(put);
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, value1);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"CONFIDENTIAL"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET"}));
            scanner = table.getScanner(s);
            Result[] next1 = scanner.next(3);
            Assert.assertEquals((long)0L, (long)next1.length);
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithPutsReAppearing() throws Exception {
        final TableName tableName = this.createTable(5);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, value);
            put.setCellVisibility(new CellVisibility("SECRET"));
            table.put(put);
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, value1);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET"));
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"CONFIDENTIAL"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET"}));
            scanner = table.getScanner(s);
            Result[] next1 = scanner.next(3);
            Assert.assertEquals((long)0L, (long)next1.length);
        }
    }

    @Test
    public void testVisibilityCombinations() throws Exception {
        final TableName tableName = this.createTable(5);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, 123L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, 124L, value1);
            put.setCellVisibility(new CellVisibility("SECRET"));
            table.put(put);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d2;
                    Throwable throwable;
                    Table table2;
                    Throwable throwable2;
                    Connection connection;
                    try {
                        connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                        throwable2 = null;
                        try {
                            table2 = connection.getTable(tableName);
                            throwable = null;
                            try {
                                d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                                d2.setCellVisibility(new CellVisibility("SECRET"));
                                d2.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 126L);
                                table2.delete(d2);
                            }
                            catch (Throwable d2) {
                                throwable = d2;
                                throw d2;
                            }
                            finally {
                                if (table2 != null) {
                                    if (throwable != null) {
                                        try {
                                            table2.close();
                                        }
                                        catch (Throwable d2) {
                                            throwable.addSuppressed(d2);
                                        }
                                    } else {
                                        table2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable table2) {
                            throwable2 = table2;
                            throw table2;
                        }
                        finally {
                            if (connection != null) {
                                if (throwable2 != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable table2) {
                                        throwable2.addSuppressed(table2);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    try {
                        connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                        throwable2 = null;
                        try {
                            table2 = connection.getTable(tableName);
                            throwable = null;
                            try {
                                d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                                d2.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                                d2.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 123L);
                                table2.delete(d2);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (table2 != null) {
                                    if (throwable != null) {
                                        try {
                                            table2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                    } else {
                                        table2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (connection != null) {
                                if (throwable2 != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable2.addSuppressed(throwable6);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"CONFIDENTIAL", "SECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)0L, (long)next.length);
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteColumnWithSpecificVersionWithPutsReAppearing() throws Exception {
        final TableName tableName = this.createTable(5);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put1 = new Put(Bytes.toBytes((String)"row1"));
            put1.addColumn(fam, qual, 123L, value);
            put1.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            Put put2 = new Put(Bytes.toBytes((String)"row1"));
            put2.addColumn(fam, qual, 123L, value1);
            put2.setCellVisibility(new CellVisibility("SECRET"));
            table.put(TestVisibilityLabelsWithDeletes.createList(put1, put2));
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"CONFIDENTIAL", "SECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Assert.assertEquals((long)1L, (long)scanner.next(3).length);
            scanner.close();
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d2;
                    Throwable throwable;
                    Table table;
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);){
                        table = connection.getTable(tableName);
                        throwable = null;
                        try {
                            d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                            d2.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                            d2.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 123L);
                            table.delete(d2);
                        }
                        catch (Throwable d2) {
                            throwable = d2;
                            throw d2;
                        }
                        finally {
                            if (table != null) {
                                if (throwable != null) {
                                    try {
                                        table.close();
                                    }
                                    catch (Throwable d2) {
                                        throwable.addSuppressed(d2);
                                    }
                                } else {
                                    table.close();
                                }
                            }
                        }
                    }
                    try {
                        connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                        var2_3 = null;
                        try {
                            table = connection.getTable(tableName);
                            throwable = null;
                            try {
                                d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                                d2.setCellVisibility(new CellVisibility("SECRET"));
                                d2.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 123L);
                                table.delete(d2);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (table != null) {
                                    if (throwable != null) {
                                        try {
                                            table.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        table.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            var2_3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (connection != null) {
                                if (var2_3 != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable5) {
                                        var2_3.addSuppressed(throwable5);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"CONFIDENTIAL"}));
            scanner = table.getScanner(s);
            Assert.assertEquals((long)0L, (long)scanner.next(3).length);
            scanner.close();
        }
    }

    @Test
    public void testVisibilityLabelsWithDeleteFamilyNoMatchingVisExpWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d1 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d1.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                    d1.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                    Delete d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d2.setCellVisibility(new CellVisibility("SECRET"));
                    d2.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                    Delete d3 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d3.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                    d3.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(TestVisibilityLabelsWithDeletes.createList(d1, d2, d3));
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            scanner.close();
        }
    }

    @Test
    public void testDeleteFamilyAndDeleteColumnsWithAndWithoutVisibilityExp() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d1 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d1.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                    Delete d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d2.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                    d2.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(TestVisibilityLabelsWithDeletes.createList(d1, d2));
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            scanner.close();
        }
    }

    private Table doPuts(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        this.createTable(tableName, 5);
        ArrayList<Put> puts = new ArrayList<Put>(5);
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 123L, value);
        put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 124L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 125L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 126L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        TEST_UTIL.getAdmin().flush(tableName);
        put = new Put(Bytes.toBytes((String)"row2"));
        put.addColumn(fam, qual, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        table.put(puts);
        return table;
    }

    private Table doPutsWithDiffCols(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        this.createTable(tableName, 5);
        ArrayList<Put> puts = new ArrayList<Put>(5);
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 123L, value);
        put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 124L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 125L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual1, 126L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual2, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        puts.add(put);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        table.put(puts);
        return table;
    }

    private Table doPutsWithoutVisibility(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        this.createTable(tableName, 5);
        ArrayList<Put> puts = new ArrayList<Put>(5);
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 123L, value);
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 124L, value);
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 125L, value);
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 126L, value);
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(fam, qual, 127L, value);
        puts.add(put);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        table.put(puts);
        TEST_UTIL.getAdmin().flush(tableName);
        put = new Put(Bytes.toBytes((String)"row2"));
        put.addColumn(fam, qual, 127L, value);
        table.put(put);
        return table;
    }

    @Test
    public void testDeleteColumnWithSpecificTimeStampUsingMultipleVersionsUnMatchingVisExpression() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnWithLatestTimeStampUsingMultipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnWithLatestTimeStampWhenNoVersionMatches() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, 128L, value);
            put.setCellVisibility(new CellVisibility("TOPSECRET"));
            table.put(put);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)128L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, 129L, value);
            put.setCellVisibility(new CellVisibility("SECRET"));
            table.put(put);
            TEST_UTIL.getAdmin().flush(tableName);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)129L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testDeleteColumnWithLatestTimeStampUsingMultipleVersionsAfterCompaction() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Put put = new Put(Bytes.toBytes((String)"row3"));
            put.addColumn(fam, qual, 127L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL&PRIVATE"));
            table.put(put);
            TEST_UTIL.getAdmin().flush(tableName);
            TEST_UTIL.getAdmin().majorCompact(tableName);
            Thread.sleep(5000L);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 3 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteFamilyLatestTimeStampWithMulipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnswithMultipleColumnsWithMultipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPutsWithDiffCols(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                    d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])qual1, (int)0, (int)qual1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])qual2, (int)0, (int)qual2.length));
        }
    }

    @Test
    public void testDeleteColumnsWithDiffColsAndTags() throws Exception {
        final TableName tableName = this.createTable(5);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual1, 125L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual1, 126L, value);
            put.setCellVisibility(new CellVisibility("SECRET"));
            table.put(put);
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d1 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d1.setCellVisibility(new CellVisibility("SECRET"));
                    d1.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 126L);
                    Delete d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d2.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                    d2.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual1, 125L);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(TestVisibilityLabelsWithDeletes.createList(d1, d2));
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "CONFIDENTIAL"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
        }
    }

    @Test
    public void testDeleteColumnsWithDiffColsAndTags1() throws Exception {
        final TableName tableName = this.createTable(5);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual1, 125L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual1, 126L, value);
            put.setCellVisibility(new CellVisibility("SECRET"));
            table.put(put);
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Delete d1 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d1.setCellVisibility(new CellVisibility("SECRET"));
                    d1.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 126L);
                    Delete d2 = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                    d2.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                    d2.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual1, 126L);
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        table.delete(TestVisibilityLabelsWithDeletes.createList(d1, d2));
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "CONFIDENTIAL"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)1L, (long)next.length);
        }
    }

    @Test
    public void testDeleteFamilyWithoutCellVisibilityWithMulipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPutsWithoutVisibility(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteFamilyLatestTimeStampWithMulipleVersionsWithoutCellVisibilityInPuts() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPutsWithoutVisibility(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteFamilySpecificTimeStampWithMulipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(6);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testScanAfterCompaction() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Put put = new Put(Bytes.toBytes((String)"row3"));
            put.addColumn(fam, qual, 127L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL&PRIVATE"));
            table.put(put);
            TEST_UTIL.getAdmin().flush(tableName);
            TEST_UTIL.getAdmin().compact(tableName);
            Thread.sleep(5000L);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 3 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteFamilySpecificTimeStampWithMulipleVersionsDoneTwice() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testMultipleDeleteFamilyVersionWithDiffLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths((Connection)conn, (String[])new String[]{"CONFIDENTIAL", "PRIVATE", "SECRET"}, (String)VisibilityLabelsWithDeletesTestBase.SUPERUSER.getShortName());
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                        d.addFamilyVersion(VisibilityLabelsWithDeletesTestBase.fam, 123L);
                        table.delete(d);
                        d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addFamilyVersion(VisibilityLabelsWithDeletesTestBase.fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testSpecificDeletesFollowedByDeleteFamily() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 126L);
                        table.delete(d);
                        d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addFamilyVersion(VisibilityLabelsWithDeletesTestBase.fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testSpecificDeletesFollowedByDeleteFamily1() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths((Connection)conn, (String[])new String[]{"CONFIDENTIAL", "PRIVATE", "SECRET"}, (String)VisibilityLabelsWithDeletesTestBase.SUPERUSER.getShortName());
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                        d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addFamilyVersion(VisibilityLabelsWithDeletesTestBase.fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice1() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice2() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testDeleteColumnAndDeleteFamilylSpecificTimeStampWithMulipleVersion() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam, 124L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testDiffDeleteTypesForTheSameCellUsingMultipleVersions() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)127L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)126L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)125L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    @Test
    public void testDeleteColumnLatestWithNoCellVisibility() throws Exception {
        this.setAuths();
        final TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        try (Table table = this.doPuts(tableName);){
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.addFamily(VisibilityLabelsWithDeletesTestBase.fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.addColumns(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.addFamilyVersion(VisibilityLabelsWithDeletesTestBase.fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
        }
    }

    private void scanAll(Result[] next) throws IOException {
        CellScanner cellScanner = next[0].cellScanner();
        cellScanner.advance();
        Cell current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)127L, (long)current.getTimestamp());
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)126L, (long)current.getTimestamp());
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)125L, (long)current.getTimestamp());
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)124L, (long)current.getTimestamp());
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)123L, (long)current.getTimestamp());
        cellScanner = next[1].cellScanner();
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
    }

    @Test
    public void testVisibilityExpressionWithNotEqualORCondition() throws Exception {
        this.setAuths();
        final TableName tableName = this.createTable(5);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, 123L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL"));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.addColumn(fam, qual, 124L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL|PRIVATE"));
            table.put(put);
            TEST_UTIL.getAdmin().flush(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)VisibilityLabelsWithDeletesTestBase.conf);
                         Table table = connection.getTable(tableName);){
                        Delete d = new Delete(VisibilityLabelsWithDeletesTestBase.row1);
                        d.addColumn(VisibilityLabelsWithDeletesTestBase.fam, VisibilityLabelsWithDeletesTestBase.qual, 124L);
                        d.setCellVisibility(new CellVisibility("PRIVATE"));
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getAdmin().flush(tableName);
            Scan s = new Scan();
            s.readVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE", "CONFIDENTIAL", "TOPSECRET"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)124L, (long)current.getTimestamp());
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)123L, (long)current.getTimestamp());
        }
    }

    @Test
    public void testDeleteWithNoVisibilitiesForPutsAndDeletes() throws Exception {
        TableName tableName = this.createTable(5);
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(fam, qual, value);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        table.put(p);
        p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(fam, qual1, value);
        table.put(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.addColumn(fam, qual, value);
        table.put(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.addColumn(fam, qual1, value);
        table.put(p);
        Delete d = new Delete(Bytes.toBytes((String)"row1"));
        table.delete(d);
        Get g = new Get(Bytes.toBytes((String)"row1"));
        g.readAllVersions();
        g.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE"}));
        Result result = table.get(g);
        Assert.assertEquals((long)0L, (long)result.rawCells().length);
        p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(fam, qual, value);
        table.put(p);
        result = table.get(g);
        Assert.assertEquals((long)1L, (long)result.rawCells().length);
    }

    @Test
    public void testDeleteWithFamilyDeletesOfSameTsButDifferentVisibilities() throws Exception {
        TableName tableName = this.createTable(5);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        long t1 = 1234L;
        CellVisibility cellVisibility1 = new CellVisibility("SECRET");
        CellVisibility cellVisibility2 = new CellVisibility("PRIVATE");
        Put p = new Put(row1);
        p.addColumn(fam, qual, t1, value);
        p.setCellVisibility(cellVisibility1);
        table.put(p);
        p = new Put(row1);
        p.addColumn(fam, qual1, t1, value);
        p.setCellVisibility(cellVisibility2);
        table.put(p);
        Delete d = new Delete(row1);
        d.addFamily(fam, t1);
        d.setCellVisibility(cellVisibility2);
        table.delete(d);
        d = new Delete(row1);
        d.addFamily(fam, t1);
        d.setCellVisibility(cellVisibility1);
        table.delete(d);
        Get g = new Get(row1);
        g.readAllVersions();
        g.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE"}));
        Result result = table.get(g);
        Assert.assertEquals((long)0L, (long)result.rawCells().length);
        p = new Put(row2);
        p.addColumn(fam, qual, t1, value);
        p.setCellVisibility(cellVisibility1);
        table.put(p);
        p = new Put(row2);
        p.addColumn(fam, qual1, t1, value);
        p.setCellVisibility(cellVisibility2);
        table.put(p);
        d = new Delete(row2);
        d.addFamilyVersion(fam, t1);
        d.setCellVisibility(cellVisibility2);
        table.delete(d);
        d = new Delete(row2);
        d.addFamilyVersion(fam, t1);
        d.setCellVisibility(cellVisibility1);
        table.delete(d);
        g = new Get(row2);
        g.readAllVersions();
        g.setAuthorizations(new Authorizations(new String[]{"SECRET", "PRIVATE"}));
        result = table.get(g);
        Assert.assertEquals((long)0L, (long)result.rawCells().length);
    }

    @SafeVarargs
    public static <T> List<T> createList(T ... ts) {
        return new ArrayList<T>(Arrays.asList(ts));
    }

    private static Delete addDeleteMark(Delete d, DeleteMark mark, long now) {
        switch (mark) {
            case ROW: {
                break;
            }
            case FAMILY: {
                d.addFamily(fam);
                break;
            }
            case FAMILY_VERSION: {
                d.addFamilyVersion(fam, now);
                break;
            }
            case COLUMN: {
                d.addColumns(fam, qual);
                break;
            }
            case CELL: {
                d.addColumn(fam, qual);
                break;
            }
        }
        return d;
    }

    @Test
    public void testDeleteCellWithoutVisibility() throws IOException, InterruptedException {
        for (DeleteMark mark : DeleteMark.values()) {
            this.testDeleteCellWithoutVisibility(mark);
        }
    }

    private void testDeleteCellWithoutVisibility(DeleteMark mark) throws IOException, InterruptedException {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)("testDeleteCellWithoutVisibility-" + mark.name()));
        this.createTable(tableName, 5);
        long now = EnvironmentEdgeManager.currentTime();
        ArrayList<Put> puts = new ArrayList<Put>(1);
        Put put = new Put(row1);
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value);
        } else {
            put.addColumn(fam, qual, value);
        }
        puts.add(put);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            table.put(puts);
            Result r = table.get(new Get(row1));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Delete d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    @Test
    public void testDeleteCellWithVisibility() throws IOException, InterruptedException {
        for (DeleteMark mark : DeleteMark.values()) {
            this.testDeleteCellWithVisibility(mark);
            this.testDeleteCellWithVisibilityV2(mark);
        }
    }

    private void testDeleteCellWithVisibility(DeleteMark mark) throws IOException, InterruptedException {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)("testDeleteCellWithVisibility-" + mark.name()));
        this.createTable(tableName, 5);
        long now = EnvironmentEdgeManager.currentTime();
        ArrayList<Put> puts = new ArrayList<Put>(2);
        Put put = new Put(row1);
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value);
        } else {
            put.addColumn(fam, qual, value);
        }
        puts.add(put);
        put = new Put(row1);
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value1);
        } else {
            put.addColumn(fam, qual, value1);
        }
        put.setCellVisibility(new CellVisibility("PRIVATE"));
        puts.add(put);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            table.put(puts);
            Result r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{"PRIVATE"})));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Delete d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{"PRIVATE"})));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1).setCellVisibility(new CellVisibility("PRIVATE")), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{"PRIVATE"})));
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    private void testDeleteCellWithVisibilityV2(DeleteMark mark) throws IOException, InterruptedException {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)("testDeleteCellWithVisibilityV2-" + mark.name()));
        this.createTable(tableName, 5);
        long now = EnvironmentEdgeManager.currentTime();
        ArrayList<Put> puts = new ArrayList<Put>(2);
        Put put = new Put(row1);
        put.setCellVisibility(new CellVisibility("PRIVATE"));
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value);
        } else {
            put.addColumn(fam, qual, value);
        }
        puts.add(put);
        put = new Put(row1);
        if (mark == DeleteMark.FAMILY_VERSION) {
            put.addColumn(fam, qual, now, value1);
        } else {
            put.addColumn(fam, qual, value1);
        }
        puts.add(put);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            table.put(puts);
            Result r = table.get(new Get(row1));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{"PRIVATE"})));
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Delete d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{"PRIVATE"})));
            Assert.assertEquals((long)0L, (long)r.size());
            d = TestVisibilityLabelsWithDeletes.addDeleteMark(new Delete(row1).setCellVisibility(new CellVisibility("PRIVATE")), mark, now);
            table.delete(d);
            r = table.get(new Get(row1));
            Assert.assertEquals((long)0L, (long)r.size());
            r = table.get(new Get(row1).setAuthorizations(new Authorizations(new String[]{"PRIVATE"})));
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    private static enum DeleteMark {
        ROW,
        FAMILY,
        FAMILY_VERSION,
        COLUMN,
        CELL;

    }
}

