/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.security.HadoopSecurityEnabledUserProviderForTesting;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.tool.TestBulkLoadHFiles;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, LargeTests.class})
public class TestSecureBulkLoadHFiles
extends TestBulkLoadHFiles {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecureBulkLoadHFiles.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UserProvider.setUserProviderForTesting((Configuration)util.getConfiguration(), HadoopSecurityEnabledUserProviderForTesting.class);
        SecureTestUtil.enableSecurity(util.getConfiguration());
        util.getConfiguration().setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", 4);
        util.getConfiguration().set("hbase.client.rpc.codec", KeyValueCodecWithTags.class.getCanonicalName());
        util.startMiniCluster();
        util.waitTableEnabled(PermissionStorage.ACL_TABLE_NAME);
        TestSecureBulkLoadHFiles.setupNamespace();
    }
}

