/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool.coprocessor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorValidator;
import org.apache.hadoop.hbase.tool.coprocessor.CoprocessorViolation;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class CoprocessorValidatorTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(CoprocessorValidatorTest.class);
    private CoprocessorValidator validator = new CoprocessorValidator();

    public CoprocessorValidatorTest() {
        this.validator.setConf(HBaseConfiguration.create());
    }

    private static ClassLoader getClassLoader() {
        return CoprocessorValidatorTest.class.getClassLoader();
    }

    private static String getFullClassName(String className) {
        return CoprocessorValidatorTest.class.getName() + "$" + className;
    }

    private List<CoprocessorViolation> validateClass(String className) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return this.validateClass(classLoader, className);
    }

    private List<CoprocessorViolation> validateClass(ClassLoader classLoader, String className) {
        ArrayList classNames = Lists.newArrayList((Object[])new String[]{CoprocessorValidatorTest.getFullClassName(className)});
        ArrayList<CoprocessorViolation> violations = new ArrayList<CoprocessorViolation>();
        this.validator.validateClasses(classLoader, (List)classNames, violations);
        return violations;
    }

    @Test
    public void testNoSuchClass() throws IOException {
        List<CoprocessorViolation> violations = this.validateClass("NoSuchClass");
        Assert.assertEquals((long)1L, (long)violations.size());
        CoprocessorViolation violation = violations.get(0);
        Assert.assertEquals((Object)CoprocessorValidatorTest.getFullClassName("NoSuchClass"), (Object)violation.getClassName());
        Assert.assertEquals((Object)CoprocessorViolation.Severity.ERROR, (Object)violation.getSeverity());
        String stackTrace = Throwables.getStackTraceAsString((Throwable)violation.getThrowable());
        Assert.assertTrue((boolean)stackTrace.contains("java.lang.ClassNotFoundException: org.apache.hadoop.hbase.tool.coprocessor.CoprocessorValidatorTest$NoSuchClass"));
    }

    @Test
    public void testMissingClass() throws IOException {
        MissingClassClassLoader missingClassClassLoader = new MissingClassClassLoader();
        List<CoprocessorViolation> violations = this.validateClass(missingClassClassLoader, "MissingClassObserver");
        Assert.assertEquals((long)1L, (long)violations.size());
        CoprocessorViolation violation = violations.get(0);
        Assert.assertEquals((Object)CoprocessorValidatorTest.getFullClassName("MissingClassObserver"), (Object)violation.getClassName());
        Assert.assertEquals((Object)CoprocessorViolation.Severity.ERROR, (Object)violation.getSeverity());
        String stackTrace = Throwables.getStackTraceAsString((Throwable)violation.getThrowable());
        Assert.assertTrue((boolean)stackTrace.contains("java.lang.ClassNotFoundException: org.apache.hadoop.hbase.tool.coprocessor.CoprocessorValidatorTest$MissingClass"));
    }

    @Test
    public void testObsoleteMethod() throws IOException {
        List<CoprocessorViolation> violations = this.validateClass("ObsoleteMethodObserver");
        Assert.assertEquals((long)1L, (long)violations.size());
        CoprocessorViolation violation = violations.get(0);
        Assert.assertEquals((Object)CoprocessorViolation.Severity.WARNING, (Object)violation.getSeverity());
        Assert.assertEquals((Object)CoprocessorValidatorTest.getFullClassName("ObsoleteMethodObserver"), (Object)violation.getClassName());
        Assert.assertTrue((boolean)violation.getMessage().contains("was removed from new coprocessor API"));
    }

    private List<CoprocessorViolation> validateTable(String jarFile, String className) throws IOException {
        Pattern pattern = Pattern.compile(".*");
        Admin admin = (Admin)Mockito.mock(Admin.class);
        TableDescriptor tableDescriptor = (TableDescriptor)Mockito.mock(TableDescriptor.class);
        ArrayList tableDescriptors = Lists.newArrayList((Object[])new TableDescriptor[]{tableDescriptor});
        ((Admin)Mockito.doReturn((Object)tableDescriptors).when((Object)admin)).listTableDescriptors(pattern);
        CoprocessorDescriptor coprocessorDescriptor = (CoprocessorDescriptor)Mockito.mock(CoprocessorDescriptor.class);
        ArrayList coprocessorDescriptors = Lists.newArrayList((Object[])new CoprocessorDescriptor[]{coprocessorDescriptor});
        ((TableDescriptor)Mockito.doReturn((Object)coprocessorDescriptors).when((Object)tableDescriptor)).getCoprocessorDescriptors();
        ((CoprocessorDescriptor)Mockito.doReturn((Object)CoprocessorValidatorTest.getFullClassName(className)).when((Object)coprocessorDescriptor)).getClassName();
        ((CoprocessorDescriptor)Mockito.doReturn(Optional.ofNullable(jarFile)).when((Object)coprocessorDescriptor)).getJarPath();
        ArrayList<CoprocessorViolation> violations = new ArrayList<CoprocessorViolation>();
        this.validator.validateTables(CoprocessorValidatorTest.getClassLoader(), admin, pattern, violations);
        return violations;
    }

    @Test
    public void testTableNoSuchClass() throws IOException {
        List<CoprocessorViolation> violations = this.validateTable(null, "NoSuchClass");
        Assert.assertEquals((long)1L, (long)violations.size());
        CoprocessorViolation violation = violations.get(0);
        Assert.assertEquals((Object)CoprocessorValidatorTest.getFullClassName("NoSuchClass"), (Object)violation.getClassName());
        Assert.assertEquals((Object)CoprocessorViolation.Severity.ERROR, (Object)violation.getSeverity());
        String stackTrace = Throwables.getStackTraceAsString((Throwable)violation.getThrowable());
        Assert.assertTrue((boolean)stackTrace.contains("java.lang.ClassNotFoundException: org.apache.hadoop.hbase.tool.coprocessor.CoprocessorValidatorTest$NoSuchClass"));
    }

    @Test
    public void testTableMissingJar() throws IOException {
        List<CoprocessorViolation> violations = this.validateTable("no such file", "NoSuchClass");
        Assert.assertEquals((long)1L, (long)violations.size());
        CoprocessorViolation violation = violations.get(0);
        Assert.assertEquals((Object)CoprocessorValidatorTest.getFullClassName("NoSuchClass"), (Object)violation.getClassName());
        Assert.assertEquals((Object)CoprocessorViolation.Severity.ERROR, (Object)violation.getSeverity());
        Assert.assertTrue((boolean)violation.getMessage().contains("could not validate jar file 'no such file'"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableValidJar() throws IOException {
        Path outputDirectory = Paths.get("target", "test-classes");
        String className = CoprocessorValidatorTest.getFullClassName("ObsoleteMethodObserver");
        Path classFile = Paths.get(className.replace('.', '/') + ".class", new String[0]);
        Path fullClassFile = outputDirectory.resolve(classFile);
        Path tempJarFile = Files.createTempFile("coprocessor-validator-test-", ".jar", new FileAttribute[0]);
        try {
            try (OutputStream fileStream = Files.newOutputStream(tempJarFile, new OpenOption[0]);
                 JarOutputStream jarStream = new JarOutputStream(fileStream);
                 InputStream classStream = Files.newInputStream(fullClassFile, new OpenOption[0]);){
                ZipEntry entry = new ZipEntry(classFile.toString());
                jarStream.putNextEntry(entry);
                ByteStreams.copy((InputStream)classStream, (OutputStream)jarStream);
            }
            String tempJarFileUri = tempJarFile.toUri().toString();
            List<CoprocessorViolation> violations = this.validateTable(tempJarFileUri, "ObsoleteMethodObserver");
            Assert.assertEquals((long)1L, (long)violations.size());
            CoprocessorViolation violation = violations.get(0);
            Assert.assertEquals((Object)CoprocessorValidatorTest.getFullClassName("ObsoleteMethodObserver"), (Object)violation.getClassName());
            Assert.assertEquals((Object)CoprocessorViolation.Severity.WARNING, (Object)violation.getSeverity());
            Assert.assertTrue((boolean)violation.getMessage().contains("was removed from new coprocessor API"));
        }
        finally {
            Files.delete(tempJarFile);
        }
    }

    private static class ObsoleteMethodObserver {
        private ObsoleteMethodObserver() {
        }

        public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tablName) throws IOException {
        }
    }

    private static class MissingClassClassLoader
    extends ClassLoader {
        public MissingClassClassLoader() {
            super(CoprocessorValidatorTest.getClassLoader());
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.equals(CoprocessorValidatorTest.getFullClassName("MissingClass"))) {
                throw new ClassNotFoundException(name);
            }
            return super.findClass(name);
        }
    }

    private static class MissingClassObserver {
        private MissingClassObserver() {
        }

        public void method(MissingClass missingClass) {
        }
    }

    private static class MissingClass {
        private MissingClass() {
        }
    }
}

