/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore
@Category(value={MiscTests.class, MediumTests.class})
public class TestHBaseFsckEncryption {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseFsckEncryption.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private Configuration conf;
    private TableDescriptor tableDescriptor;
    private Key cfKey;

    @Before
    public void setUp() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setInt("hfile.format.version", 3);
        this.conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        this.conf.set("hbase.crypto.master.key.name", "hbase");
        byte[] keyBytes = new byte[16];
        Bytes.secureRandom((byte[])keyBytes);
        String algorithm = this.conf.get("hbase.crypto.key.algorithm", "AES");
        this.cfKey = new SecretKeySpec(keyBytes, algorithm);
        TEST_UTIL.startMiniCluster(3);
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"default", (String)"TestHBaseFsckEncryption"));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf")).setEncryptionType(algorithm).setEncryptionKey(EncryptionUtil.wrapKey((Configuration)this.conf, (String)this.conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), (Key)this.cfKey)).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        this.tableDescriptor = tableDescriptorBuilder.build();
        TEST_UTIL.getAdmin().createTable(this.tableDescriptor);
        TEST_UTIL.waitTableAvailable(this.tableDescriptor.getTableName(), 5000L);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckWithEncryption() throws Exception {
        try (Table table = TEST_UTIL.getConnection().getTable(this.tableDescriptor.getTableName());){
            byte[] values = new byte[]{65, 66, 67, 68};
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < values.length; ++j) {
                    Put put = new Put(new byte[]{values[i], values[j]});
                    put.addColumn(Bytes.toBytes((String)"cf"), new byte[0], new byte[]{values[i], values[j]});
                    table.put(put);
                }
            }
        }
        TEST_UTIL.getAdmin().flush(this.tableDescriptor.getTableName());
        List<Path> paths = this.findStorefilePaths(this.tableDescriptor.getTableName());
        Assert.assertTrue((paths.size() > 0 ? 1 : 0) != 0);
        for (Path path : paths) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])this.cfKey.getEncoded(), (byte[])this.extractHFileKey(path)));
        }
        HBaseFsck res = HbckTestingUtil.doHFileQuarantine(this.conf, this.tableDescriptor.getTableName());
        Assert.assertEquals((long)0L, (long)res.getRetCode());
        HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
        Assert.assertEquals((long)0L, (long)hfcc.getCorrupted().size());
        Assert.assertEquals((long)0L, (long)hfcc.getFailures().size());
        Assert.assertEquals((long)0L, (long)hfcc.getQuarantined().size());
        Assert.assertEquals((long)0L, (long)hfcc.getMissing().size());
    }

    private List<Path> findStorefilePaths(TableName tableName) throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Region region : TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegions(this.tableDescriptor.getTableName())) {
            for (HStore store : ((HRegion)region).getStores()) {
                for (HStoreFile storefile : store.getStorefiles()) {
                    paths.add(storefile.getPath());
                }
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] extractHFileKey(Path path) throws Exception {
        try (HFile.Reader reader = HFile.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)path, (CacheConfig)new CacheConfig(this.conf), (boolean)true, (Configuration)this.conf);){
            Encryption.Context cryptoContext = reader.getFileContext().getEncryptionContext();
            Assert.assertNotNull((String)"Reader has a null crypto context", (Object)cryptoContext);
            Key key = cryptoContext.getKey();
            Assert.assertNotNull((String)"Crypto context has no key", (Object)key);
            byte[] byArray = key.getEncoded();
            return byArray;
        }
    }
}

