/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HbckErrorReporter;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestHBaseFsckReplication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseFsckReplication.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    @Rule
    public final TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.write.hbck1.lock.file", false);
        UTIL.startMiniCluster(1);
        TableName tableName = TableName.valueOf((String)("replication_" + this.name.getMethodName()));
        UTIL.getAdmin().createTable(ReplicationStorageFactory.createReplicationQueueTableDescriptor((TableName)tableName));
        UTIL.getConfiguration().set("hbase.replication.queue.table.name", tableName.getNameAsString());
    }

    @After
    public void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        ReplicationPeerStorage peerStorage = ReplicationStorageFactory.getReplicationPeerStorage((FileSystem)UTIL.getTestFileSystem(), (ZKWatcher)UTIL.getZooKeeperWatcher(), (Configuration)UTIL.getConfiguration());
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((Connection)UTIL.getConnection(), (Configuration)UTIL.getConfiguration());
        String peerId1 = "1";
        String peerId2 = "2";
        peerStorage.addPeer(peerId1, ReplicationPeerConfig.newBuilder().setClusterKey("key").build(), true, SyncReplicationState.NONE);
        peerStorage.addPeer(peerId2, ReplicationPeerConfig.newBuilder().setClusterKey("key").build(), true, SyncReplicationState.NONE);
        ReplicationQueueId queueId = null;
        for (int i = 0; i < 10; ++i) {
            queueId = new ReplicationQueueId(this.getServerName(i), peerId1);
            queueStorage.setOffset(queueId, "group-" + i, new ReplicationGroupOffset("file-" + i, (long)(i * 100)), Collections.emptyMap());
        }
        queueId = new ReplicationQueueId(this.getServerName(0), peerId2);
        queueStorage.setOffset(queueId, "group-0", new ReplicationGroupOffset("file-0", 100L), Collections.emptyMap());
        HBaseFsck fsck = HbckTestingUtil.doFsck(UTIL.getConfiguration(), true);
        HbckTestingUtil.assertNoErrors(fsck);
        Assert.assertEquals((long)10L, (long)queueStorage.listAllReplicators().size());
        peerStorage.removePeer(peerId1);
        Assert.assertEquals((long)10L, (long)queueStorage.listAllReplicators().size());
        fsck = HbckTestingUtil.doFsck(UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(fsck, (HbckErrorReporter.ERROR_CODE[])Stream.generate(() -> HbckErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE).limit(10L).toArray(HbckErrorReporter.ERROR_CODE[]::new));
        Assert.assertEquals((long)10L, (long)queueStorage.listAllReplicators().size());
        fsck = HbckTestingUtil.doFsck(UTIL.getConfiguration(), true);
        HbckTestingUtil.assertErrors(fsck, (HbckErrorReporter.ERROR_CODE[])Stream.generate(() -> HbckErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE).limit(10L).toArray(HbckErrorReporter.ERROR_CODE[]::new));
        List replicators = queueStorage.listAllReplicators();
        Assert.assertEquals((long)1L, (long)replicators.size());
        Assert.assertEquals((Object)ServerName.valueOf((String)"localhost", (int)10000, (long)100000L), replicators.get(0));
        for (ReplicationQueueId qId : queueStorage.listAllQueueIds((ServerName)replicators.get(0))) {
            Assert.assertEquals((Object)peerId2, (Object)qId.getPeerId());
        }
    }

    private ServerName getServerName(int i) {
        return ServerName.valueOf((String)"localhost", (int)(10000 + i), (long)(100000 + i));
    }
}

