/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.RegionMover;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionMoverWithRSGroupEnable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMoverWithRSGroupEnable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionMoverWithRSGroupEnable.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final String TEST_RSGROUP = "test";
    private final List<Address> rsservers = new ArrayList<Address>(2);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        RSGroupUtil.enableRSGroup((Configuration)TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(5);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.addRSGroup(TEST_RSGROUP);
        Collection allServers = admin.getRegionServers();
        ServerName rsContainMeta = TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).filter(rs -> rs.getRegions(TableName.META_TABLE_NAME).size() > 0).findFirst().get().getServerName();
        LOG.info("{} contains hbase:meta", (Object)rsContainMeta);
        ArrayList modifiable = new ArrayList(allServers);
        modifiable.remove(rsContainMeta);
        int i = 0;
        for (ServerName server : modifiable) {
            if (i == 2) break;
            this.rsservers.add(Address.fromParts((String)server.getHostname(), (int)server.getPort()));
            ++i;
        }
        admin.moveServersToRSGroup(new HashSet<Address>(this.rsservers), TEST_RSGROUP);
        LOG.info("Servers in {} are {}", (Object)TEST_RSGROUP, this.rsservers);
        Assert.assertEquals((long)3L, (long)admin.getRSGroup("default").getServers().size());
        Assert.assertEquals((long)2L, (long)admin.getRSGroup(TEST_RSGROUP).getServers().size());
        TableName tableName = TableName.valueOf((String)"testRegionMoverWithRSGroupEnable");
        if (admin.tableExists(tableName)) {
            TEST_UTIL.deleteTable(tableName);
        }
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).setRegionServerGroup(TEST_RSGROUP).build();
        String startKey = "a";
        String endKey = "z";
        admin.createTable(tableDesc, Bytes.toBytes((String)startKey), Bytes.toBytes((String)endKey), 9);
    }

    @Test
    public void testUnloadRegions() throws Exception {
        Address decommission = this.rsservers.get(0);
        Address online = this.rsservers.get(1);
        String filename = new Path(TEST_UTIL.getDataTestDir(), "testRSGroupUnload").toString();
        RegionMover.RegionMoverBuilder builder = new RegionMover.RegionMoverBuilder(decommission.toString(), TEST_UTIL.getConfiguration());
        try (RegionMover rm = builder.filename(filename).ack(true).build();){
            LOG.info("Unloading " + decommission.getHostname());
            rm.unload();
        }
        HRegionServer onlineRS = TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).filter(rs -> rs.getServerName().getAddress().equals((Object)online)).findFirst().get();
        Assert.assertEquals((long)9L, (long)onlineRS.getNumberOfOnlineRegions());
    }
}

