/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRaceBetweenGetWALAndGetWALs {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRaceBetweenGetWALAndGetWALs.class);
    private static Future<List<WAL>> GET_WALS_FUTURE;

    @Test
    public void testRace() throws IOException, InterruptedException, ExecutionException {
        FSWALProvider p = new FSWALProvider();
        WAL wal = p.getWAL(null);
        Assert.assertNotNull(GET_WALS_FUTURE);
        List<WAL> wals = GET_WALS_FUTURE.get();
        Assert.assertSame((Object)wal, (Object)Iterables.getOnlyElement(wals));
    }

    private static final class FSWALProvider
    extends AbstractFSWALProvider<AbstractFSWAL<?>> {
        private FSWALProvider() {
        }

        protected AbstractFSWAL<?> createWAL() throws IOException {
            GET_WALS_FUTURE = ForkJoinPool.commonPool().submit(() -> ((FSWALProvider)this).getWALs());
            Threads.sleep((long)2000L);
            return (AbstractFSWAL)Mockito.mock(AbstractFSWAL.class);
        }

        protected void doInit(Configuration conf) throws IOException {
        }
    }
}

