/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ServiceCaller;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcChannel;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncHBaseAdmin
implements AsyncAdmin {
    private final RawAsyncHBaseAdmin rawAdmin;
    private final ExecutorService pool;

    AsyncHBaseAdmin(RawAsyncHBaseAdmin rawAdmin, ExecutorService pool) {
        this.rawAdmin = rawAdmin;
        this.pool = pool;
    }

    private <T> CompletableFuture<T> wrap(CompletableFuture<T> future) {
        return FutureUtils.wrapFuture(future, this.pool);
    }

    @Override
    public CompletableFuture<Boolean> tableExists(TableName tableName) {
        return this.wrap(this.rawAdmin.tableExists(tableName));
    }

    @Override
    public CompletableFuture<List<TableDescriptor>> listTableDescriptors(boolean includeSysTables) {
        return this.wrap(this.rawAdmin.listTableDescriptors(includeSysTables));
    }

    @Override
    public CompletableFuture<List<TableDescriptor>> listTableDescriptors(Pattern pattern, boolean includeSysTables) {
        return this.wrap(this.rawAdmin.listTableDescriptors(pattern, includeSysTables));
    }

    @Override
    public CompletableFuture<List<TableDescriptor>> listTableDescriptorsByNamespace(String name) {
        return this.wrap(this.rawAdmin.listTableDescriptorsByNamespace(name));
    }

    @Override
    public CompletableFuture<List<TableName>> listTableNames(boolean includeSysTables) {
        return this.wrap(this.rawAdmin.listTableNames(includeSysTables));
    }

    @Override
    public CompletableFuture<List<TableName>> listTableNames(Pattern pattern, boolean includeSysTables) {
        return this.wrap(this.rawAdmin.listTableNames(pattern, includeSysTables));
    }

    @Override
    public CompletableFuture<List<TableName>> listTableNamesByNamespace(String name) {
        return this.wrap(this.rawAdmin.listTableNamesByNamespace(name));
    }

    @Override
    public CompletableFuture<TableDescriptor> getDescriptor(TableName tableName) {
        return this.wrap(this.rawAdmin.getDescriptor(tableName));
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc) {
        return this.wrap(this.rawAdmin.createTable(desc));
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) {
        return this.wrap(this.rawAdmin.createTable(desc, startKey, endKey, numRegions));
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc, byte[][] splitKeys) {
        return this.wrap(this.rawAdmin.createTable(desc, splitKeys));
    }

    @Override
    public CompletableFuture<Void> modifyTable(TableDescriptor desc) {
        return this.wrap(this.rawAdmin.modifyTable(desc));
    }

    @Override
    public CompletableFuture<Void> deleteTable(TableName tableName) {
        return this.wrap(this.rawAdmin.deleteTable(tableName));
    }

    @Override
    public CompletableFuture<Void> truncateTable(TableName tableName, boolean preserveSplits) {
        return this.wrap(this.rawAdmin.truncateTable(tableName, preserveSplits));
    }

    @Override
    public CompletableFuture<Void> enableTable(TableName tableName) {
        return this.wrap(this.rawAdmin.enableTable(tableName));
    }

    @Override
    public CompletableFuture<Void> disableTable(TableName tableName) {
        return this.wrap(this.rawAdmin.disableTable(tableName));
    }

    @Override
    public CompletableFuture<Boolean> isTableEnabled(TableName tableName) {
        return this.wrap(this.rawAdmin.isTableEnabled(tableName));
    }

    @Override
    public CompletableFuture<Boolean> isTableDisabled(TableName tableName) {
        return this.wrap(this.rawAdmin.isTableDisabled(tableName));
    }

    @Override
    public CompletableFuture<Boolean> isTableAvailable(TableName tableName) {
        return this.wrap(this.rawAdmin.isTableAvailable(tableName));
    }

    @Override
    public CompletableFuture<Boolean> isTableAvailable(TableName tableName, byte[][] splitKeys) {
        return this.wrap(this.rawAdmin.isTableAvailable(tableName, splitKeys));
    }

    @Override
    public CompletableFuture<Void> addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) {
        return this.wrap(this.rawAdmin.addColumnFamily(tableName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> deleteColumnFamily(TableName tableName, byte[] columnFamily) {
        return this.wrap(this.rawAdmin.deleteColumnFamily(tableName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) {
        return this.wrap(this.rawAdmin.modifyColumnFamily(tableName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> createNamespace(NamespaceDescriptor descriptor) {
        return this.wrap(this.rawAdmin.createNamespace(descriptor));
    }

    @Override
    public CompletableFuture<Void> modifyNamespace(NamespaceDescriptor descriptor) {
        return this.wrap(this.rawAdmin.modifyNamespace(descriptor));
    }

    @Override
    public CompletableFuture<Void> deleteNamespace(String name) {
        return this.wrap(this.rawAdmin.deleteNamespace(name));
    }

    @Override
    public CompletableFuture<NamespaceDescriptor> getNamespaceDescriptor(String name) {
        return this.wrap(this.rawAdmin.getNamespaceDescriptor(name));
    }

    @Override
    public CompletableFuture<List<NamespaceDescriptor>> listNamespaceDescriptors() {
        return this.wrap(this.rawAdmin.listNamespaceDescriptors());
    }

    @Override
    public CompletableFuture<List<RegionInfo>> getRegions(ServerName serverName) {
        return this.wrap(this.rawAdmin.getRegions(serverName));
    }

    @Override
    public CompletableFuture<List<RegionInfo>> getRegions(TableName tableName) {
        return this.wrap(this.rawAdmin.getRegions(tableName));
    }

    @Override
    public CompletableFuture<Void> flush(TableName tableName) {
        return this.wrap(this.rawAdmin.flush(tableName));
    }

    @Override
    public CompletableFuture<Void> flushRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.flushRegion(regionName));
    }

    @Override
    public CompletableFuture<Void> flushRegionServer(ServerName sn) {
        return this.wrap(this.rawAdmin.flushRegionServer(sn));
    }

    @Override
    public CompletableFuture<Void> compact(TableName tableName, CompactType compactType) {
        return this.wrap(this.rawAdmin.compact(tableName, compactType));
    }

    @Override
    public CompletableFuture<Void> compact(TableName tableName, byte[] columnFamily, CompactType compactType) {
        return this.wrap(this.rawAdmin.compact(tableName, columnFamily, compactType));
    }

    @Override
    public CompletableFuture<Void> compactRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.compactRegion(regionName));
    }

    @Override
    public CompletableFuture<Void> compactRegion(byte[] regionName, byte[] columnFamily) {
        return this.wrap(this.rawAdmin.compactRegion(regionName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> majorCompact(TableName tableName, CompactType compactType) {
        return this.wrap(this.rawAdmin.majorCompact(tableName, compactType));
    }

    @Override
    public CompletableFuture<Void> majorCompact(TableName tableName, byte[] columnFamily, CompactType compactType) {
        return this.wrap(this.rawAdmin.majorCompact(tableName, columnFamily, compactType));
    }

    @Override
    public CompletableFuture<Void> majorCompactRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.majorCompactRegion(regionName));
    }

    @Override
    public CompletableFuture<Void> majorCompactRegion(byte[] regionName, byte[] columnFamily) {
        return this.wrap(this.rawAdmin.majorCompactRegion(regionName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> compactRegionServer(ServerName serverName) {
        return this.wrap(this.rawAdmin.compactRegionServer(serverName));
    }

    @Override
    public CompletableFuture<Void> majorCompactRegionServer(ServerName serverName) {
        return this.wrap(this.rawAdmin.majorCompactRegionServer(serverName));
    }

    @Override
    public CompletableFuture<Boolean> mergeSwitch(boolean on) {
        return this.wrap(this.rawAdmin.mergeSwitch(on));
    }

    @Override
    public CompletableFuture<Boolean> isMergeEnabled() {
        return this.wrap(this.rawAdmin.isMergeEnabled());
    }

    @Override
    public CompletableFuture<Boolean> splitSwitch(boolean on) {
        return this.wrap(this.rawAdmin.splitSwitch(on));
    }

    @Override
    public CompletableFuture<Boolean> isSplitEnabled() {
        return this.wrap(this.rawAdmin.isSplitEnabled());
    }

    @Override
    public CompletableFuture<Void> mergeRegions(List<byte[]> nameOfRegionsToMerge, boolean forcible) {
        return this.wrap(this.rawAdmin.mergeRegions(nameOfRegionsToMerge, forcible));
    }

    @Override
    public CompletableFuture<Void> split(TableName tableName) {
        return this.wrap(this.rawAdmin.split(tableName));
    }

    @Override
    public CompletableFuture<Void> split(TableName tableName, byte[] splitPoint) {
        return this.wrap(this.rawAdmin.split(tableName, splitPoint));
    }

    @Override
    public CompletableFuture<Void> splitRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.splitRegion(regionName));
    }

    @Override
    public CompletableFuture<Void> splitRegion(byte[] regionName, byte[] splitPoint) {
        return this.wrap(this.rawAdmin.splitRegion(regionName, splitPoint));
    }

    @Override
    public CompletableFuture<Void> assign(byte[] regionName) {
        return this.wrap(this.rawAdmin.assign(regionName));
    }

    @Override
    public CompletableFuture<Void> unassign(byte[] regionName, boolean forcible) {
        return this.wrap(this.rawAdmin.unassign(regionName, forcible));
    }

    @Override
    public CompletableFuture<Void> offline(byte[] regionName) {
        return this.wrap(this.rawAdmin.offline(regionName));
    }

    @Override
    public CompletableFuture<Void> move(byte[] regionName) {
        return this.wrap(this.rawAdmin.move(regionName));
    }

    @Override
    public CompletableFuture<Void> move(byte[] regionName, ServerName destServerName) {
        return this.wrap(this.rawAdmin.move(regionName, destServerName));
    }

    @Override
    public CompletableFuture<Void> setQuota(QuotaSettings quota) {
        return this.wrap(this.rawAdmin.setQuota(quota));
    }

    @Override
    public CompletableFuture<List<QuotaSettings>> getQuota(QuotaFilter filter) {
        return this.wrap(this.rawAdmin.getQuota(filter));
    }

    @Override
    public CompletableFuture<Void> addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) {
        return this.wrap(this.rawAdmin.addReplicationPeer(peerId, peerConfig, enabled));
    }

    @Override
    public CompletableFuture<Void> removeReplicationPeer(String peerId) {
        return this.wrap(this.rawAdmin.removeReplicationPeer(peerId));
    }

    @Override
    public CompletableFuture<Void> enableReplicationPeer(String peerId) {
        return this.wrap(this.rawAdmin.enableReplicationPeer(peerId));
    }

    @Override
    public CompletableFuture<Void> disableReplicationPeer(String peerId) {
        return this.wrap(this.rawAdmin.disableReplicationPeer(peerId));
    }

    @Override
    public CompletableFuture<ReplicationPeerConfig> getReplicationPeerConfig(String peerId) {
        return this.wrap(this.rawAdmin.getReplicationPeerConfig(peerId));
    }

    @Override
    public CompletableFuture<Void> updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) {
        return this.wrap(this.rawAdmin.updateReplicationPeerConfig(peerId, peerConfig));
    }

    @Override
    public CompletableFuture<Void> appendReplicationPeerTableCFs(String peerId, Map<TableName, List<String>> tableCfs) {
        return this.wrap(this.rawAdmin.appendReplicationPeerTableCFs(peerId, tableCfs));
    }

    @Override
    public CompletableFuture<Void> removeReplicationPeerTableCFs(String peerId, Map<TableName, List<String>> tableCfs) {
        return this.wrap(this.rawAdmin.removeReplicationPeerTableCFs(peerId, tableCfs));
    }

    @Override
    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers() {
        return this.wrap(this.rawAdmin.listReplicationPeers());
    }

    @Override
    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(Pattern pattern) {
        return this.wrap(this.rawAdmin.listReplicationPeers(pattern));
    }

    @Override
    public CompletableFuture<List<TableCFs>> listReplicatedTableCFs() {
        return this.wrap(this.rawAdmin.listReplicatedTableCFs());
    }

    @Override
    public CompletableFuture<Void> enableTableReplication(TableName tableName) {
        return this.wrap(this.rawAdmin.enableTableReplication(tableName));
    }

    @Override
    public CompletableFuture<Void> disableTableReplication(TableName tableName) {
        return this.wrap(this.rawAdmin.disableTableReplication(tableName));
    }

    @Override
    public CompletableFuture<Void> snapshot(SnapshotDescription snapshot) {
        return this.wrap(this.rawAdmin.snapshot(snapshot));
    }

    @Override
    public CompletableFuture<Boolean> isSnapshotFinished(SnapshotDescription snapshot) {
        return this.wrap(this.rawAdmin.isSnapshotFinished(snapshot));
    }

    @Override
    public CompletableFuture<Void> restoreSnapshot(String snapshotName) {
        return this.wrap(this.rawAdmin.restoreSnapshot(snapshotName));
    }

    @Override
    public CompletableFuture<Void> restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        return this.wrap(this.rawAdmin.restoreSnapshot(snapshotName, takeFailSafeSnapshot));
    }

    @Override
    public CompletableFuture<Void> cloneSnapshot(String snapshotName, TableName tableName) {
        return this.wrap(this.rawAdmin.cloneSnapshot(snapshotName, tableName));
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listSnapshots() {
        return this.wrap(this.rawAdmin.listSnapshots());
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listSnapshots(Pattern pattern) {
        return this.wrap(this.rawAdmin.listSnapshots(pattern));
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern tableNamePattern) {
        return this.wrap(this.rawAdmin.listTableSnapshots(tableNamePattern));
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        return this.wrap(this.rawAdmin.listTableSnapshots(tableNamePattern, snapshotNamePattern));
    }

    @Override
    public CompletableFuture<Void> deleteSnapshot(String snapshotName) {
        return this.wrap(this.rawAdmin.deleteSnapshot(snapshotName));
    }

    @Override
    public CompletableFuture<Void> deleteSnapshots() {
        return this.wrap(this.rawAdmin.deleteSnapshots());
    }

    @Override
    public CompletableFuture<Void> deleteSnapshots(Pattern pattern) {
        return this.wrap(this.rawAdmin.deleteSnapshots(pattern));
    }

    @Override
    public CompletableFuture<Void> deleteTableSnapshots(Pattern tableNamePattern) {
        return this.wrap(this.rawAdmin.deleteTableSnapshots(tableNamePattern));
    }

    @Override
    public CompletableFuture<Void> deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        return this.wrap(this.rawAdmin.deleteTableSnapshots(tableNamePattern, snapshotNamePattern));
    }

    @Override
    public CompletableFuture<Void> execProcedure(String signature, String instance, Map<String, String> props) {
        return this.wrap(this.rawAdmin.execProcedure(signature, instance, props));
    }

    @Override
    public CompletableFuture<byte[]> execProcedureWithReturn(String signature, String instance, Map<String, String> props) {
        return this.wrap(this.rawAdmin.execProcedureWithReturn(signature, instance, props));
    }

    @Override
    public CompletableFuture<Boolean> isProcedureFinished(String signature, String instance, Map<String, String> props) {
        return this.wrap(this.rawAdmin.isProcedureFinished(signature, instance, props));
    }

    @Override
    public CompletableFuture<Boolean> abortProcedure(long procId, boolean mayInterruptIfRunning) {
        return this.wrap(this.rawAdmin.abortProcedure(procId, mayInterruptIfRunning));
    }

    @Override
    public CompletableFuture<String> getProcedures() {
        return this.wrap(this.rawAdmin.getProcedures());
    }

    @Override
    public CompletableFuture<String> getLocks() {
        return this.wrap(this.rawAdmin.getLocks());
    }

    @Override
    public CompletableFuture<Void> decommissionRegionServers(List<ServerName> servers, boolean offload) {
        return this.wrap(this.rawAdmin.decommissionRegionServers(servers, offload));
    }

    @Override
    public CompletableFuture<List<ServerName>> listDecommissionedRegionServers() {
        return this.wrap(this.rawAdmin.listDecommissionedRegionServers());
    }

    @Override
    public CompletableFuture<Void> recommissionRegionServer(ServerName server, List<byte[]> encodedRegionNames) {
        return this.wrap(this.rawAdmin.recommissionRegionServer(server, encodedRegionNames));
    }

    @Override
    public CompletableFuture<ClusterMetrics> getClusterMetrics() {
        return this.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class));
    }

    @Override
    public CompletableFuture<ClusterMetrics> getClusterMetrics(EnumSet<ClusterMetrics.Option> options) {
        return this.wrap(this.rawAdmin.getClusterMetrics(options));
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        return this.wrap(this.rawAdmin.shutdown());
    }

    @Override
    public CompletableFuture<Void> stopMaster() {
        return this.wrap(this.rawAdmin.stopMaster());
    }

    @Override
    public CompletableFuture<Void> stopRegionServer(ServerName serverName) {
        return this.wrap(this.rawAdmin.stopRegionServer(serverName));
    }

    @Override
    public CompletableFuture<Void> updateConfiguration(ServerName serverName) {
        return this.wrap(this.rawAdmin.updateConfiguration(serverName));
    }

    @Override
    public CompletableFuture<Void> updateConfiguration() {
        return this.wrap(this.rawAdmin.updateConfiguration());
    }

    @Override
    public CompletableFuture<Void> rollWALWriter(ServerName serverName) {
        return this.wrap(this.rawAdmin.rollWALWriter(serverName));
    }

    @Override
    public CompletableFuture<Void> clearCompactionQueues(ServerName serverName, Set<String> queues) {
        return this.wrap(this.rawAdmin.clearCompactionQueues(serverName, queues));
    }

    @Override
    public CompletableFuture<List<SecurityCapability>> getSecurityCapabilities() {
        return this.wrap(this.rawAdmin.getSecurityCapabilities());
    }

    @Override
    public CompletableFuture<List<RegionMetrics>> getRegionMetrics(ServerName serverName) {
        return this.wrap(this.rawAdmin.getRegionMetrics(serverName));
    }

    @Override
    public CompletableFuture<List<RegionMetrics>> getRegionMetrics(ServerName serverName, TableName tableName) {
        return this.wrap(this.rawAdmin.getRegionMetrics(serverName, tableName));
    }

    @Override
    public CompletableFuture<Boolean> isMasterInMaintenanceMode() {
        return this.wrap(this.rawAdmin.isMasterInMaintenanceMode());
    }

    @Override
    public CompletableFuture<CompactionState> getCompactionState(TableName tableName, CompactType compactType) {
        return this.wrap(this.rawAdmin.getCompactionState(tableName, compactType));
    }

    @Override
    public CompletableFuture<CompactionState> getCompactionStateForRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.getCompactionStateForRegion(regionName));
    }

    @Override
    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestamp(TableName tableName) {
        return this.wrap(this.rawAdmin.getLastMajorCompactionTimestamp(tableName));
    }

    @Override
    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestampForRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.getLastMajorCompactionTimestampForRegion(regionName));
    }

    @Override
    public CompletableFuture<Boolean> balancerSwitch(boolean on) {
        return this.wrap(this.rawAdmin.balancerSwitch(on));
    }

    @Override
    public CompletableFuture<Boolean> balance(boolean forcible) {
        return this.wrap(this.rawAdmin.balance(forcible));
    }

    @Override
    public CompletableFuture<Boolean> isBalancerEnabled() {
        return this.wrap(this.rawAdmin.isBalancerEnabled());
    }

    @Override
    public CompletableFuture<Boolean> normalizerSwitch(boolean on) {
        return this.wrap(this.rawAdmin.normalizerSwitch(on));
    }

    @Override
    public CompletableFuture<Boolean> isNormalizerEnabled() {
        return this.wrap(this.rawAdmin.isNormalizerEnabled());
    }

    @Override
    public CompletableFuture<Boolean> normalize() {
        return this.wrap(this.rawAdmin.normalize());
    }

    @Override
    public CompletableFuture<Boolean> cleanerChoreSwitch(boolean enabled) {
        return this.wrap(this.rawAdmin.cleanerChoreSwitch(enabled));
    }

    @Override
    public CompletableFuture<Boolean> isCleanerChoreEnabled() {
        return this.wrap(this.rawAdmin.isCleanerChoreEnabled());
    }

    @Override
    public CompletableFuture<Boolean> runCleanerChore() {
        return this.wrap(this.rawAdmin.runCleanerChore());
    }

    @Override
    public CompletableFuture<Boolean> catalogJanitorSwitch(boolean enabled) {
        return this.wrap(this.rawAdmin.catalogJanitorSwitch(enabled));
    }

    @Override
    public CompletableFuture<Boolean> isCatalogJanitorEnabled() {
        return this.wrap(this.rawAdmin.isCatalogJanitorEnabled());
    }

    @Override
    public CompletableFuture<Integer> runCatalogJanitor() {
        return this.wrap(this.rawAdmin.runCatalogJanitor());
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable) {
        return this.wrap(this.rawAdmin.coprocessorService(stubMaker, callable));
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, ServiceCaller<S, R> callable, ServerName serverName) {
        return this.wrap(this.rawAdmin.coprocessorService(stubMaker, callable, serverName));
    }

    @Override
    public CompletableFuture<List<ServerName>> listDeadServers() {
        return this.wrap(this.rawAdmin.listDeadServers());
    }

    @Override
    public CompletableFuture<List<ServerName>> clearDeadServers(List<ServerName> servers) {
        return this.wrap(this.rawAdmin.clearDeadServers(servers));
    }

    @Override
    public CompletableFuture<CacheEvictionStats> clearBlockCache(TableName tableName) {
        return this.wrap(this.rawAdmin.clearBlockCache(tableName));
    }

    @Override
    public CompletableFuture<Void> cloneTableSchema(TableName tableName, TableName newTableName, boolean preserveSplits) {
        return this.wrap(this.rawAdmin.cloneTableSchema(tableName, newTableName, preserveSplits));
    }
}

