/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.net.smtp;

import java.io.IOException;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.hbase.shaded.org.apache.commons.net.smtp.SMTPReply;
import org.apache.hadoop.hbase.shaded.org.apache.commons.net.smtp.SMTPSClient;
import org.apache.hadoop.hbase.shaded.org.apache.commons.net.util.Base64;

public class AuthenticatingSMTPClient
extends SMTPSClient {
    public AuthenticatingSMTPClient() throws NoSuchAlgorithmException {
    }

    public AuthenticatingSMTPClient(String protocol) throws NoSuchAlgorithmException {
        super(protocol);
    }

    public int ehlo(String hostname) throws IOException {
        return this.sendCommand(15, hostname);
    }

    public boolean elogin(String hostname) throws IOException {
        return SMTPReply.isPositiveCompletion(this.ehlo(hostname));
    }

    public boolean elogin() throws IOException {
        InetAddress host = this.getLocalAddress();
        String name = host.getHostName();
        if (name == null) {
            return false;
        }
        return SMTPReply.isPositiveCompletion(this.ehlo(name));
    }

    public int[] getEnhancedReplyCode() {
        String reply = this.getReplyString().substring(4);
        String[] parts = reply.substring(0, reply.indexOf(32)).split("\\.");
        int[] res = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            res[i] = Integer.parseInt(parts[i]);
        }
        return res;
    }

    public boolean auth(AUTH_METHOD method, String username, String password) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (!SMTPReply.isPositiveIntermediate(this.sendCommand(14, AUTH_METHOD.getAuthName(method)))) {
            return false;
        }
        if (method.equals((Object)AUTH_METHOD.PLAIN)) {
            return SMTPReply.isPositiveCompletion(this.sendCommand(new String(Base64.encodeBase64(("\u0000" + username + "\u0000" + password).getBytes()))));
        }
        if (method.equals((Object)AUTH_METHOD.CRAM_MD5)) {
            byte[] serverChallenge = Base64.decodeBase64(this.getReplyString().substring(4).trim());
            Mac hmac_md5 = Mac.getInstance("HmacMD5");
            hmac_md5.init(new SecretKeySpec(password.getBytes(), "HmacMD5"));
            byte[] hmacResult = this._convertToHexString(hmac_md5.doFinal(serverChallenge)).getBytes();
            byte[] usernameBytes = username.getBytes();
            byte[] toEncode = new byte[usernameBytes.length + 1 + hmacResult.length];
            System.arraycopy(usernameBytes, 0, toEncode, 0, usernameBytes.length);
            toEncode[usernameBytes.length] = 32;
            System.arraycopy(hmacResult, 0, toEncode, usernameBytes.length + 1, hmacResult.length);
            return SMTPReply.isPositiveCompletion(this.sendCommand(new String(Base64.encodeBase64(toEncode))));
        }
        if (method.equals((Object)AUTH_METHOD.LOGIN)) {
            if (!SMTPReply.isPositiveIntermediate(this.sendCommand(new String(Base64.encodeBase64(username.getBytes()))))) {
                return false;
            }
            return SMTPReply.isPositiveCompletion(this.sendCommand(new String(Base64.encodeBase64(password.getBytes()))));
        }
        return false;
    }

    private String _convertToHexString(byte[] a) {
        StringBuilder result = new StringBuilder(a.length * 2);
        for (int i = 0; i < a.length; ++i) {
            if ((a[i] & 0xFF) <= 15) {
                result.append("0");
            }
            result.append(Integer.toHexString(a[i] & 0xFF));
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AUTH_METHOD {
        PLAIN,
        CRAM_MD5,
        LOGIN;


        public static final String getAuthName(AUTH_METHOD method) {
            if (method.equals((Object)PLAIN)) {
                return "PLAIN";
            }
            if (method.equals((Object)CRAM_MD5)) {
                return "CRAM-MD5";
            }
            if (method.equals((Object)LOGIN)) {
                return "LOGIN";
            }
            return null;
        }
    }
}

