/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.cipher.CryptoCipherFactory;

public final class Utils {
    private static final String SYSTEM_PROPERTIES_FILE = "commons.crypto.properties";

    private Utils() {
    }

    private static Properties createDefaultProperties() {
        Properties defaultedProps = new Properties(System.getProperties());
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(SYSTEM_PROPERTIES_FILE);
            if (is == null) {
                return defaultedProps;
            }
            Properties fileProps = new Properties();
            fileProps.load(is);
            is.close();
            Enumeration<?> names = fileProps.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (System.getProperty(name) != null) continue;
                defaultedProps.setProperty(name, fileProps.getProperty(name));
            }
        }
        catch (Exception ex) {
            System.err.println("Could not load 'commons.crypto.properties' from classpath: " + ex.toString());
        }
        return defaultedProps;
    }

    public static Properties getDefaultProperties() {
        return new Properties(DefaultPropertiesHolder.DEFAULT_PROPERTIES);
    }

    public static Properties getProperties(Properties newProp) {
        Properties properties = new Properties(DefaultPropertiesHolder.DEFAULT_PROPERTIES);
        properties.putAll((Map<?, ?>)newProp);
        return properties;
    }

    public static CryptoCipher getCipherInstance(String transformation, Properties props) throws IOException {
        try {
            return CryptoCipherFactory.getCryptoCipher(transformation, props);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static List<String> splitClassNames(String clazzNames, String separator) {
        ArrayList<String> res = new ArrayList<String>();
        if (clazzNames == null || clazzNames.isEmpty()) {
            return res;
        }
        for (String clazzName : clazzNames.split(separator)) {
            if ((clazzName = clazzName.trim()).isEmpty()) continue;
            res.add(clazzName);
        }
        return res;
    }

    static /* synthetic */ Properties access$000() {
        return Utils.createDefaultProperties();
    }

    private static class DefaultPropertiesHolder {
        static final Properties DEFAULT_PROPERTIES = Utils.access$000();

        private DefaultPropertiesHolder() {
        }
    }
}

