/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferKeyOnlyKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.SizeCachedByteBufferKeyValue;
import org.apache.hadoop.hbase.SizeCachedKeyValue;
import org.apache.hadoop.hbase.SizeCachedNoTagsByteBufferKeyValue;
import org.apache.hadoop.hbase.SizeCachedNoTagsKeyValue;
import org.apache.hadoop.hbase.io.encoding.AbstractDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowIndexSeekerV1
extends AbstractDataBlockEncoder.AbstractEncodedSeeker {
    protected final ObjectIntPair<ByteBuffer> tmpPair = new ObjectIntPair();
    private ByteBuff currentBuffer;
    private SeekerState current = new SeekerState();
    private SeekerState previous = new SeekerState();
    private int rowNumber;
    private ByteBuff rowOffsets = null;
    private final CellComparator cellComparator;

    public RowIndexSeekerV1(HFileBlockDecodingContext decodingCtx) {
        super(decodingCtx);
        this.cellComparator = decodingCtx.getHFileContext().getCellComparator();
    }

    @Override
    public void setCurrentBuffer(ByteBuff buffer) {
        int onDiskSize = buffer.getInt(buffer.limit() - 4);
        ByteBuff dup = buffer.duplicate();
        dup.position(buffer.position());
        dup.limit(buffer.position() + onDiskSize);
        this.current.currentBuffer = this.currentBuffer = dup.slice();
        buffer.skip(onDiskSize);
        this.rowNumber = buffer.getInt();
        int totalRowOffsetsLength = 4 * this.rowNumber;
        ByteBuff rowDup = buffer.duplicate();
        rowDup.position(buffer.position());
        rowDup.limit(buffer.position() + totalRowOffsetsLength);
        this.rowOffsets = rowDup.slice();
        this.decodeFirst();
    }

    @Override
    public Cell getKey() {
        if (this.current.keyBuffer.hasArray()) {
            return new KeyValue.KeyOnlyKeyValue(this.current.keyBuffer.array(), this.current.keyBuffer.arrayOffset() + this.current.keyBuffer.position(), this.current.keyLength);
        }
        byte[] key = new byte[this.current.keyLength];
        ByteBufferUtils.copyFromBufferToArray(key, this.current.keyBuffer, this.current.keyBuffer.position(), 0, this.current.keyLength);
        return new KeyValue.KeyOnlyKeyValue(key, 0, this.current.keyLength);
    }

    @Override
    public ByteBuffer getValueShallowCopy() {
        this.currentBuffer.asSubByteBuffer(this.current.valueOffset, this.current.valueLength, this.tmpPair);
        ByteBuffer dup = this.tmpPair.getFirst().duplicate();
        dup.position(this.tmpPair.getSecond());
        dup.limit(this.tmpPair.getSecond() + this.current.valueLength);
        return dup.slice();
    }

    @Override
    public Cell getCell() {
        return this.current.toCell();
    }

    @Override
    public void rewind() {
        this.currentBuffer.rewind();
        this.decodeFirst();
    }

    @Override
    public boolean next() {
        if (!this.currentBuffer.hasRemaining()) {
            return false;
        }
        this.decodeNext();
        this.previous.invalidate();
        return true;
    }

    private int binarySearch(Cell seekCell, boolean seekBefore) {
        int low = 0;
        int high = this.rowNumber - 1;
        int mid = low + (high - low >> 1);
        int comp = 0;
        while (low <= high) {
            mid = low + (high - low >> 1);
            comp = this.cellComparator.compareRows(this.getRow(mid), seekCell);
            if (comp < 0) {
                low = mid + 1;
                continue;
            }
            if (comp > 0) {
                high = mid - 1;
                continue;
            }
            if (seekBefore) {
                return mid - 1;
            }
            return mid;
        }
        if (comp > 0) {
            return mid - 1;
        }
        return mid;
    }

    private ByteBuffer getRow(int index) {
        int offset = this.rowOffsets.getIntAfterPosition(index * 4);
        ByteBuff block = this.currentBuffer.duplicate();
        block.position(offset + 8);
        short rowLen = block.getShort();
        block.asSubByteBuffer(block.position(), rowLen, this.tmpPair);
        ByteBuffer row = this.tmpPair.getFirst();
        row.position(this.tmpPair.getSecond()).limit(this.tmpPair.getSecond() + rowLen);
        return row;
    }

    @Override
    public int seekToKeyInBlock(Cell seekCell, boolean seekBefore) {
        this.previous.invalidate();
        int index = this.binarySearch(seekCell, seekBefore);
        if (index < 0) {
            return -2;
        }
        int offset = this.rowOffsets.getIntAfterPosition(index * 4);
        if (offset != 0) {
            this.decodeAtPosition(offset);
        }
        while (true) {
            int comp;
            if ((comp = PrivateCellUtil.compareKeyIgnoresMvcc(this.cellComparator, seekCell, this.current.currentKey)) == 0) {
                if (seekBefore) {
                    if (!this.previous.isValid()) {
                        throw new IllegalStateException("Cannot seekBefore if positioned at the first key in the block: key=" + Bytes.toStringBinary(seekCell.getRowArray()));
                    }
                    this.moveToPrevious();
                    return 1;
                }
                return 0;
            }
            if (comp < 0) {
                if (!this.previous.isValid()) {
                    return -2;
                }
                this.moveToPrevious();
                return 1;
            }
            if (!this.currentBuffer.hasRemaining()) break;
            this.previous.copyFromNext(this.current);
            this.decodeNext();
        }
        return 1;
    }

    private void moveToPrevious() {
        if (!this.previous.isValid()) {
            throw new IllegalStateException("Can move back only once and not in first key in the block.");
        }
        SeekerState tmp = this.previous;
        this.previous = this.current;
        this.current = tmp;
        this.currentBuffer.position(this.current.nextKvOffset);
        this.previous.invalidate();
    }

    @Override
    public int compareKey(CellComparator comparator, Cell key) {
        return PrivateCellUtil.compareKeyIgnoresMvcc(comparator, key, this.current.currentKey);
    }

    protected void decodeFirst() {
        this.decodeNext();
        this.previous.invalidate();
    }

    protected void decodeAtPosition(int position) {
        this.currentBuffer.position(position);
        this.decodeNext();
        this.previous.invalidate();
    }

    protected void decodeNext() {
        this.current.startOffset = this.currentBuffer.position();
        long ll = this.currentBuffer.getLongAfterPosition(0);
        this.current.keyLength = (int)(ll >> 32);
        this.current.valueLength = (int)(0xFFFFFFFF00000000L ^ ll);
        this.currentBuffer.skip(8);
        this.currentBuffer.asSubByteBuffer(this.currentBuffer.position(), this.current.keyLength, this.tmpPair);
        ByteBuffer key = this.tmpPair.getFirst().duplicate();
        key.position(this.tmpPair.getSecond()).limit(this.tmpPair.getSecond() + this.current.keyLength);
        this.current.keyBuffer = key;
        this.currentBuffer.skip(this.current.keyLength);
        this.current.valueOffset = this.currentBuffer.position();
        this.currentBuffer.skip(this.current.valueLength);
        if (this.includesTags()) {
            this.decodeTags();
        }
        this.current.memstoreTS = this.includesMvcc() ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
        this.current.nextKvOffset = this.currentBuffer.position();
        this.current.currentKey.setKey(this.current.keyBuffer, this.tmpPair.getSecond(), this.current.keyLength);
    }

    protected void decodeTags() {
        this.current.tagsLength = this.currentBuffer.getShortAfterPosition(0);
        this.currentBuffer.skip(2);
        this.current.tagsOffset = this.currentBuffer.position();
        this.currentBuffer.skip(this.current.tagsLength);
    }

    private class SeekerState {
        public static final int KEY_VALUE_LEN_SIZE = 8;
        protected ByteBuff currentBuffer;
        protected int startOffset = -1;
        protected int valueOffset = -1;
        protected int keyLength;
        protected int valueLength;
        protected int tagsLength = 0;
        protected int tagsOffset = -1;
        protected ByteBuffer keyBuffer = null;
        protected long memstoreTS;
        protected int nextKvOffset;
        private ByteBufferKeyOnlyKeyValue currentKey = new ByteBufferKeyOnlyKeyValue();

        private SeekerState() {
        }

        protected boolean isValid() {
            return this.valueOffset != -1;
        }

        protected void invalidate() {
            this.valueOffset = -1;
            this.currentKey = new ByteBufferKeyOnlyKeyValue();
            this.currentBuffer = null;
        }

        protected void copyFromNext(SeekerState nextState) {
            this.keyBuffer = nextState.keyBuffer;
            this.currentKey.setKey(nextState.keyBuffer, nextState.currentKey.getRowPosition() - 2, nextState.keyLength);
            this.startOffset = nextState.startOffset;
            this.valueOffset = nextState.valueOffset;
            this.keyLength = nextState.keyLength;
            this.valueLength = nextState.valueLength;
            this.nextKvOffset = nextState.nextKvOffset;
            this.memstoreTS = nextState.memstoreTS;
            this.currentBuffer = nextState.currentBuffer;
            this.tagsOffset = nextState.tagsOffset;
            this.tagsLength = nextState.tagsLength;
        }

        public String toString() {
            return CellUtil.getCellKeyAsString(this.toCell());
        }

        protected int getCellBufSize() {
            int kvBufSize = 8 + this.keyLength + this.valueLength;
            if (RowIndexSeekerV1.this.includesTags() && this.tagsLength > 0) {
                kvBufSize += 2 + this.tagsLength;
            }
            return kvBufSize;
        }

        public Cell toCell() {
            ExtendedCell ret;
            int cellBufSize = this.getCellBufSize();
            long seqId = 0L;
            if (RowIndexSeekerV1.this.includesMvcc()) {
                seqId = this.memstoreTS;
            }
            if (this.currentBuffer.hasArray()) {
                ret = this.tagsLength > 0 ? new SizeCachedKeyValue(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + this.startOffset, cellBufSize, seqId, this.keyLength) : new SizeCachedNoTagsKeyValue(this.currentBuffer.array(), this.currentBuffer.arrayOffset() + this.startOffset, cellBufSize, seqId, this.keyLength);
            } else {
                this.currentBuffer.asSubByteBuffer(this.startOffset, cellBufSize, RowIndexSeekerV1.this.tmpPair);
                ByteBuffer buf = RowIndexSeekerV1.this.tmpPair.getFirst();
                ret = buf.isDirect() ? (this.tagsLength > 0 ? new SizeCachedByteBufferKeyValue(buf, RowIndexSeekerV1.this.tmpPair.getSecond(), cellBufSize, seqId, this.keyLength) : new SizeCachedNoTagsByteBufferKeyValue(buf, RowIndexSeekerV1.this.tmpPair.getSecond(), cellBufSize, seqId, this.keyLength)) : (this.tagsLength > 0 ? new SizeCachedKeyValue(buf.array(), buf.arrayOffset() + RowIndexSeekerV1.this.tmpPair.getSecond(), cellBufSize, seqId, this.keyLength) : new SizeCachedNoTagsKeyValue(buf.array(), buf.arrayOffset() + RowIndexSeekerV1.this.tmpPair.getSecond(), cellBufSize, seqId, this.keyLength));
            }
            return ret;
        }
    }
}

