/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.security.CryptoAESUnwrapHandler;
import org.apache.hadoop.hbase.security.CryptoAESWrapHandler;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.SaslUnwrapHandler;
import org.apache.hadoop.hbase.security.SaslWrapHandler;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NettyHBaseRpcConnectionHeaderHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final Promise<Boolean> saslPromise;
    private final Configuration conf;
    private final ByteBuf connectionHeaderWithLength;

    public NettyHBaseRpcConnectionHeaderHandler(Promise<Boolean> saslPromise, Configuration conf, ByteBuf connectionHeaderWithLength) {
        this.saslPromise = saslPromise;
        this.conf = conf;
        this.connectionHeaderWithLength = connectionHeaderWithLength;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        int len = msg.readInt();
        byte[] buff = new byte[len];
        msg.readBytes(buff);
        RPCProtos.ConnectionHeaderResponse connectionHeaderResponse = RPCProtos.ConnectionHeaderResponse.parseFrom(buff);
        if (connectionHeaderResponse.hasCryptoCipherMeta()) {
            CryptoAES cryptoAES = EncryptionUtil.createCryptoAES(connectionHeaderResponse.getCryptoCipherMeta(), this.conf);
            this.setupCryptoAESHandler(ctx.pipeline(), cryptoAES);
        }
        NettyFutureUtils.consume(this.saslPromise.setSuccess(true));
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        try {
            NettyFutureUtils.safeWriteAndFlush(ctx, this.connectionHeaderWithLength.retainedDuplicate());
        }
        catch (Exception e) {
            this.exceptionCaught(ctx, e);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.saslPromise.tryFailure(cause);
    }

    private void setupCryptoAESHandler(ChannelPipeline p, CryptoAES cryptoAES) {
        p.remove(SaslWrapHandler.class);
        p.remove(SaslUnwrapHandler.class);
        String lengthDecoder = p.context(LengthFieldBasedFrameDecoder.class).name();
        p.addAfter(lengthDecoder, null, new CryptoAESUnwrapHandler(cryptoAES));
        p.addAfter(lengthDecoder, null, new CryptoAESWrapHandler(cryptoAES));
    }
}

