/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class QuotaSettingsFactory {
    static List<QuotaSettings> fromUserQuotas(String userName, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(userName, null, null, null, quotas);
    }

    static List<QuotaSettings> fromUserQuotas(String userName, TableName tableName, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(userName, tableName, null, null, quotas);
    }

    static List<QuotaSettings> fromUserQuotas(String userName, String namespace, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(userName, null, namespace, null, quotas);
    }

    static List<QuotaSettings> fromTableQuotas(TableName tableName, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(null, tableName, null, null, quotas);
    }

    static List<QuotaSettings> fromNamespaceQuotas(String namespace, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(null, null, namespace, null, quotas);
    }

    static List<QuotaSettings> fromRegionServerQuotas(String regionServer, QuotaProtos.Quotas quotas) {
        return QuotaSettingsFactory.fromQuotas(null, null, null, regionServer, quotas);
    }

    private static List<QuotaSettings> fromQuotas(String userName, TableName tableName, String namespace, String regionServer, QuotaProtos.Quotas quotas) {
        ArrayList<QuotaSettings> settings = new ArrayList<QuotaSettings>();
        if (quotas.hasThrottle()) {
            settings.addAll(QuotaSettingsFactory.fromThrottle(userName, tableName, namespace, regionServer, quotas.getThrottle()));
        }
        if (quotas.getBypassGlobals()) {
            settings.add(new QuotaGlobalsSettingsBypass(userName, tableName, namespace, regionServer, true));
        }
        if (quotas.hasSpace()) {
            settings.add(QuotaSettingsFactory.fromSpace(tableName, namespace, quotas.getSpace()));
        }
        return settings;
    }

    public static List<ThrottleSettings> fromTableThrottles(TableName tableName, QuotaProtos.Throttle throttle) {
        return QuotaSettingsFactory.fromThrottle(null, tableName, null, null, throttle);
    }

    protected static List<ThrottleSettings> fromThrottle(String userName, TableName tableName, String namespace, String regionServer, QuotaProtos.Throttle throttle) {
        ArrayList<ThrottleSettings> settings = new ArrayList<ThrottleSettings>();
        if (throttle.hasReqNum()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.REQUEST_NUMBER, throttle.getReqNum()));
        }
        if (throttle.hasReqSize()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.REQUEST_SIZE, throttle.getReqSize()));
        }
        if (throttle.hasWriteNum()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.WRITE_NUMBER, throttle.getWriteNum()));
        }
        if (throttle.hasWriteSize()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.WRITE_SIZE, throttle.getWriteSize()));
        }
        if (throttle.hasReadNum()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.READ_NUMBER, throttle.getReadNum()));
        }
        if (throttle.hasReadSize()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.READ_SIZE, throttle.getReadSize()));
        }
        if (throttle.hasReqCapacityUnit()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.REQUEST_CAPACITY_UNIT, throttle.getReqCapacityUnit()));
        }
        if (throttle.hasReadCapacityUnit()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.READ_CAPACITY_UNIT, throttle.getReadCapacityUnit()));
        }
        if (throttle.hasWriteCapacityUnit()) {
            settings.add(ThrottleSettings.fromTimedQuota(userName, tableName, namespace, regionServer, ThrottleType.WRITE_CAPACITY_UNIT, throttle.getWriteCapacityUnit()));
        }
        return settings;
    }

    static QuotaSettings fromSpace(TableName table, String namespace, QuotaProtos.SpaceQuota protoQuota) {
        if (protoQuota == null) {
            return null;
        }
        if (table == null && namespace == null || table != null && namespace != null) {
            throw new IllegalArgumentException("Can only construct SpaceLimitSettings for a table or namespace.");
        }
        if (table != null) {
            if (protoQuota.getRemove()) {
                return new SpaceLimitSettings(table);
            }
            return SpaceLimitSettings.fromSpaceQuota(table, protoQuota);
        }
        if (protoQuota.getRemove()) {
            return new SpaceLimitSettings(namespace);
        }
        return SpaceLimitSettings.fromSpaceQuota(namespace, protoQuota);
    }

    public static QuotaSettings throttleUser(String userName, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttleUser(userName, type, limit, timeUnit, QuotaScope.MACHINE);
    }

    public static QuotaSettings throttleUser(String userName, ThrottleType type, long limit, TimeUnit timeUnit, QuotaScope scope) {
        return QuotaSettingsFactory.throttle(userName, null, null, null, type, limit, timeUnit, scope);
    }

    public static QuotaSettings throttleUser(String userName, TableName tableName, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttleUser(userName, tableName, type, limit, timeUnit, QuotaScope.MACHINE);
    }

    public static QuotaSettings throttleUser(String userName, TableName tableName, ThrottleType type, long limit, TimeUnit timeUnit, QuotaScope scope) {
        return QuotaSettingsFactory.throttle(userName, tableName, null, null, type, limit, timeUnit, scope);
    }

    public static QuotaSettings throttleUser(String userName, String namespace, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttleUser(userName, namespace, type, limit, timeUnit, QuotaScope.MACHINE);
    }

    public static QuotaSettings throttleUser(String userName, String namespace, ThrottleType type, long limit, TimeUnit timeUnit, QuotaScope scope) {
        return QuotaSettingsFactory.throttle(userName, null, namespace, null, type, limit, timeUnit, scope);
    }

    public static QuotaSettings unthrottleUser(String userName) {
        return QuotaSettingsFactory.throttle(userName, null, null, null, null, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleUserByThrottleType(String userName, ThrottleType type) {
        return QuotaSettingsFactory.throttle(userName, null, null, null, type, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleUser(String userName, TableName tableName) {
        return QuotaSettingsFactory.throttle(userName, tableName, null, null, null, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleUserByThrottleType(String userName, TableName tableName, ThrottleType type) {
        return QuotaSettingsFactory.throttle(userName, tableName, null, null, type, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleUser(String userName, String namespace) {
        return QuotaSettingsFactory.throttle(userName, null, namespace, null, null, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleUserByThrottleType(String userName, String namespace, ThrottleType type) {
        return QuotaSettingsFactory.throttle(userName, null, namespace, null, type, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings throttleTable(TableName tableName, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttleTable(tableName, type, limit, timeUnit, QuotaScope.MACHINE);
    }

    public static QuotaSettings throttleTable(TableName tableName, ThrottleType type, long limit, TimeUnit timeUnit, QuotaScope scope) {
        return QuotaSettingsFactory.throttle(null, tableName, null, null, type, limit, timeUnit, scope);
    }

    public static QuotaSettings unthrottleTable(TableName tableName) {
        return QuotaSettingsFactory.throttle(null, tableName, null, null, null, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleTableByThrottleType(TableName tableName, ThrottleType type) {
        return QuotaSettingsFactory.throttle(null, tableName, null, null, type, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings throttleNamespace(String namespace, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttleNamespace(namespace, type, limit, timeUnit, QuotaScope.MACHINE);
    }

    public static QuotaSettings throttleNamespace(String namespace, ThrottleType type, long limit, TimeUnit timeUnit, QuotaScope scope) {
        return QuotaSettingsFactory.throttle(null, null, namespace, null, type, limit, timeUnit, scope);
    }

    public static QuotaSettings unthrottleNamespace(String namespace) {
        return QuotaSettingsFactory.throttle(null, null, namespace, null, null, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleNamespaceByThrottleType(String namespace, ThrottleType type) {
        return QuotaSettingsFactory.throttle(null, null, namespace, null, type, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings throttleRegionServer(String regionServer, ThrottleType type, long limit, TimeUnit timeUnit) {
        return QuotaSettingsFactory.throttle(null, null, null, regionServer, type, limit, timeUnit, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleRegionServer(String regionServer) {
        return QuotaSettingsFactory.throttle(null, null, null, regionServer, null, 0L, null, QuotaScope.MACHINE);
    }

    public static QuotaSettings unthrottleRegionServerByThrottleType(String regionServer, ThrottleType type) {
        return QuotaSettingsFactory.throttle(null, null, null, regionServer, type, 0L, null, QuotaScope.MACHINE);
    }

    private static QuotaSettings throttle(String userName, TableName tableName, String namespace, String regionServer, ThrottleType type, long limit, TimeUnit timeUnit, QuotaScope scope) {
        QuotaProtos.ThrottleRequest.Builder builder = QuotaProtos.ThrottleRequest.newBuilder();
        if (type != null) {
            builder.setType(ProtobufUtil.toProtoThrottleType(type));
        }
        if (timeUnit != null) {
            builder.setTimedQuota(ProtobufUtil.toTimedQuota(limit, timeUnit, scope));
        }
        return new ThrottleSettings(userName, tableName, namespace, regionServer, builder.build());
    }

    public static QuotaSettings bypassGlobals(String userName, boolean bypassGlobals) {
        return new QuotaGlobalsSettingsBypass(userName, null, null, null, bypassGlobals);
    }

    public static QuotaSettings limitTableSpace(TableName tableName, long sizeLimit, SpaceViolationPolicy violationPolicy) {
        return new SpaceLimitSettings(tableName, sizeLimit, violationPolicy);
    }

    public static QuotaSettings removeTableSpaceLimit(TableName tableName) {
        return new SpaceLimitSettings(tableName);
    }

    public static QuotaSettings limitNamespaceSpace(String namespace, long sizeLimit, SpaceViolationPolicy violationPolicy) {
        return new SpaceLimitSettings(namespace, sizeLimit, violationPolicy);
    }

    public static QuotaSettings removeNamespaceSpaceLimit(String namespace) {
        return new SpaceLimitSettings(namespace);
    }

    static class QuotaGlobalsSettingsBypass
    extends QuotaSettings {
        private final boolean bypassGlobals;

        QuotaGlobalsSettingsBypass(String userName, TableName tableName, String namespace, String regionServer, boolean bypassGlobals) {
            super(userName, tableName, namespace, regionServer);
            this.bypassGlobals = bypassGlobals;
        }

        @Override
        public QuotaType getQuotaType() {
            return QuotaType.GLOBAL_BYPASS;
        }

        @Override
        protected void setupSetQuotaRequest(MasterProtos.SetQuotaRequest.Builder builder) {
            builder.setBypassGlobals(this.bypassGlobals);
        }

        public String toString() {
            return "GLOBAL_BYPASS => " + this.bypassGlobals;
        }

        protected boolean getBypass() {
            return this.bypassGlobals;
        }

        @Override
        protected QuotaGlobalsSettingsBypass merge(QuotaSettings newSettings) throws IOException {
            if (newSettings instanceof QuotaGlobalsSettingsBypass) {
                QuotaGlobalsSettingsBypass other = (QuotaGlobalsSettingsBypass)newSettings;
                this.validateQuotaTarget(other);
                if (this.getBypass() != other.getBypass()) {
                    return other;
                }
            }
            return this;
        }
    }
}

