/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.crypto;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

final class OsInfo {
    private static final HashMap<String, String> archMapping = new HashMap();
    static final String X86 = "x86";
    static final String X86_64 = "x86_64";
    static final String IA64_32 = "ia64_32";
    static final String IA64 = "ia64";
    static final String PPC = "ppc";
    static final String PPC64 = "ppc64";

    private OsInfo() {
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            if ("--os".equals(args[0])) {
                System.out.print(OsInfo.getOSName());
                return;
            }
            if ("--arch".equals(args[0])) {
                System.out.print(OsInfo.getArchName());
                return;
            }
        }
        System.out.print(OsInfo.getNativeLibFolderPathForCurrentOS());
    }

    static String getNativeLibFolderPathForCurrentOS() {
        return OsInfo.getOSName() + "/" + OsInfo.getArchName();
    }

    static String getOSName() {
        return OsInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    static String getArchName() {
        String osArch = System.getProperty("os.arch");
        if (osArch.startsWith("arm") && System.getProperty("os.name").contains("Linux")) {
            String javaHome = System.getProperty("java.home");
            try {
                String[] cmdarray = new String[]{"/bin/sh", "-c", "find '" + javaHome + "' -name 'libjvm.so' | head -1 | xargs readelf -A | grep 'Tag_ABI_VFP_args: VFP registers'"};
                int exitCode = Runtime.getRuntime().exec(cmdarray).waitFor();
                if (exitCode == 0) {
                    return "armhf";
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        } else {
            String lc = osArch.toLowerCase(Locale.US);
            if (archMapping.containsKey(lc)) {
                return archMapping.get(lc);
            }
        }
        return OsInfo.translateArchNameToFolderName(osArch);
    }

    private static String translateOSNameToFolderName(String osName) {
        if (osName.contains("Windows")) {
            return "Windows";
        }
        if (osName.contains("Mac")) {
            return "Mac";
        }
        if (osName.contains("Linux")) {
            return "Linux";
        }
        if (osName.contains("AIX")) {
            return "AIX";
        }
        return osName.replaceAll("\\W", "");
    }

    private static String translateArchNameToFolderName(String archName) {
        return archName.replaceAll("\\W", "");
    }

    static {
        archMapping.put(X86, X86);
        archMapping.put("i386", X86);
        archMapping.put("i486", X86);
        archMapping.put("i586", X86);
        archMapping.put("i686", X86);
        archMapping.put("pentium", X86);
        archMapping.put(X86_64, X86_64);
        archMapping.put("amd64", X86_64);
        archMapping.put("em64t", X86_64);
        archMapping.put("universal", X86_64);
        archMapping.put(IA64, IA64);
        archMapping.put("ia64w", IA64);
        archMapping.put(IA64_32, IA64_32);
        archMapping.put("ia64n", IA64_32);
        archMapping.put(PPC, PPC);
        archMapping.put("power", PPC);
        archMapping.put("powerpc", PPC);
        archMapping.put("power_pc", PPC);
        archMapping.put("power_rs", PPC);
        archMapping.put(PPC64, PPC64);
        archMapping.put("power64", PPC64);
        archMapping.put("powerpc64", PPC64);
        archMapping.put("power_pc64", PPC64);
        archMapping.put("power_rs64", PPC64);
    }
}

