/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.SaslAuthenticationProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Authentication"})
@InterfaceStability.Evolving
public interface SaslClientAuthenticationProvider
extends SaslAuthenticationProvider {
    @Deprecated
    default public SaslClient createClient(Configuration conf, InetAddress serverAddr, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
        throw new UnsupportedOperationException("should not be used any more");
    }

    default public SaslClient createClient(Configuration conf, InetAddress serverAddr, String serverPrincipal, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
        String principalKey = "hbase.fake.kerberos.principal";
        conf.set(principalKey, serverPrincipal);
        return this.createClient(conf, serverAddr, new SecurityInfo(principalKey, AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN), token, fallbackAllowed, saslProps);
    }

    public RPCProtos.UserInformation getUserInfo(User var1);

    default public UserGroupInformation getRealUser(User ugi) {
        return ugi.getUGI();
    }

    default public boolean canRetry() {
        return false;
    }

    default public void relogin() throws IOException {
    }
}

