/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Threads {
    private static final Logger LOG = LoggerFactory.getLogger(Threads.class);
    public static final Thread.UncaughtExceptionHandler LOGGING_EXCEPTION_HANDLER = (t, e) -> LOG.warn("Thread:{} exited with Exception:{}", (Object)t, (Object)StringUtils.stringifyException((Throwable)e));

    public static <T extends Thread> T setDaemonThreadRunning(T t) {
        return Threads.setDaemonThreadRunning(t, t.getName());
    }

    public static <T extends Thread> T setDaemonThreadRunning(T t, String name) {
        return Threads.setDaemonThreadRunning(t, name, null);
    }

    public static <T extends Thread> T setDaemonThreadRunning(T t, String name, Thread.UncaughtExceptionHandler handler) {
        t.setName(name);
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        }
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static void shutdown(Thread t) {
        Threads.shutdown(t, 0L);
    }

    public static void shutdown(Thread t, long joinwait) {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            try {
                t.join(joinwait);
            }
            catch (InterruptedException e) {
                LOG.warn(t.getName() + "; joinwait=" + joinwait, (Throwable)e);
            }
        }
    }

    public static void threadDumpingIsAlive(Thread t) throws InterruptedException {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            t.join(60000L);
            if (!t.isAlive()) continue;
            Threads.printThreadInfo(System.out, "Automatic Stack Trace every 60 seconds waiting on " + t.getName());
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.warn("sleep interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void sleepWithoutInterrupt(long msToWait) {
        long timeMillis = EnvironmentEdgeManager.currentTime();
        long endTime = timeMillis + msToWait;
        boolean interrupted = false;
        while (timeMillis < endTime) {
            try {
                Thread.sleep(endTime - timeMillis);
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
            timeMillis = EnvironmentEdgeManager.currentTime();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadPoolExecutor getBoundedCachedThreadPool(int maxCachedThread, long timeout, TimeUnit unit, ThreadFactory threadFactory) {
        ThreadPoolExecutor boundedCachedThreadPool = new ThreadPoolExecutor(maxCachedThread, maxCachedThread, timeout, unit, new LinkedBlockingQueue<Runnable>(), threadFactory);
        boundedCachedThreadPool.allowCoreThreadTimeOut(true);
        return boundedCachedThreadPool;
    }

    public static void setLoggingUncaughtExceptionHandler(Thread t) {
        t.setUncaughtExceptionHandler(LOGGING_EXCEPTION_HANDLER);
    }

    public static void printThreadInfo(PrintStream stream, String title) {
        ReflectionUtils.printThreadInfo(stream, title);
    }
}

