/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class CheckAndMutate
implements Row {
    private final byte[] row;
    private final byte[] family;
    private final byte[] qualifier;
    private final CompareOperator op;
    private final byte[] value;
    private final Filter filter;
    private final TimeRange timeRange;
    private final Row action;

    public static Builder newBuilder(byte[] row) {
        return new Builder(row);
    }

    private CheckAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, TimeRange timeRange, Row action) {
        this.row = row;
        this.family = family;
        this.qualifier = qualifier;
        this.op = op;
        this.value = value;
        this.filter = null;
        this.timeRange = timeRange != null ? timeRange : TimeRange.allTime();
        this.action = action;
    }

    private CheckAndMutate(byte[] row, Filter filter, TimeRange timeRange, Row action) {
        this.row = row;
        this.family = null;
        this.qualifier = null;
        this.op = null;
        this.value = null;
        this.filter = filter;
        this.timeRange = timeRange != null ? timeRange : TimeRange.allTime();
        this.action = action;
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public CompareOperator getCompareOp() {
        return this.op;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public Row getAction() {
        return this.action;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static final class Builder {
        private final byte[] row;
        private byte[] family;
        private byte[] qualifier;
        private CompareOperator op;
        private byte[] value;
        private Filter filter;
        private TimeRange timeRange;

        private Builder(byte[] row) {
            this.row = Preconditions.checkNotNull(row, "row is null");
        }

        public Builder ifNotExists(byte[] family, byte[] qualifier) {
            return this.ifEquals(family, qualifier, null);
        }

        public Builder ifEquals(byte[] family, byte[] qualifier, byte[] value) {
            return this.ifMatches(family, qualifier, CompareOperator.EQUAL, value);
        }

        public Builder ifMatches(byte[] family, byte[] qualifier, CompareOperator compareOp, byte[] value) {
            this.family = Preconditions.checkNotNull(family, "family is null");
            this.qualifier = qualifier;
            this.op = Preconditions.checkNotNull(compareOp, "compareOp is null");
            this.value = value;
            return this;
        }

        public Builder ifMatches(Filter filter) {
            this.filter = Preconditions.checkNotNull(filter, "filter is null");
            return this;
        }

        public Builder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        private void preCheck(Row action) {
            Preconditions.checkNotNull(action, "action is null");
            if (!Bytes.equals(this.row, action.getRow())) {
                throw new IllegalArgumentException("The row of the action <" + Bytes.toStringBinary(action.getRow()) + "> doesn't match the original one <" + Bytes.toStringBinary(this.row) + ">");
            }
            Preconditions.checkState(this.op != null || this.filter != null, "condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before building a CheckAndMutate object");
        }

        public CheckAndMutate build(Put put) {
            this.preCheck(put);
            if (this.filter != null) {
                return new CheckAndMutate(this.row, this.filter, this.timeRange, put);
            }
            return new CheckAndMutate(this.row, this.family, this.qualifier, this.op, this.value, this.timeRange, put);
        }

        public CheckAndMutate build(Delete delete) {
            this.preCheck(delete);
            if (this.filter != null) {
                return new CheckAndMutate(this.row, this.filter, this.timeRange, delete);
            }
            return new CheckAndMutate(this.row, this.family, this.qualifier, this.op, this.value, this.timeRange, delete);
        }

        public CheckAndMutate build(Increment increment) {
            this.preCheck(increment);
            if (this.filter != null) {
                return new CheckAndMutate(this.row, this.filter, this.timeRange, increment);
            }
            return new CheckAndMutate(this.row, this.family, this.qualifier, this.op, this.value, this.timeRange, increment);
        }

        public CheckAndMutate build(Append append) {
            this.preCheck(append);
            if (this.filter != null) {
                return new CheckAndMutate(this.row, this.filter, this.timeRange, append);
            }
            return new CheckAndMutate(this.row, this.family, this.qualifier, this.op, this.value, this.timeRange, append);
        }

        public CheckAndMutate build(RowMutations mutations) {
            this.preCheck(mutations);
            if (this.filter != null) {
                return new CheckAndMutate(this.row, this.filter, this.timeRange, mutations);
            }
            return new CheckAndMutate(this.row, this.family, this.qualifier, this.op, this.value, this.timeRange, mutations);
        }
    }
}

