/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AbstractRpcBasedConnectionRegistry;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.hbase.thirdparty.com.google.common.net.HostAndPort;
import org.apache.yetus.audience.InterfaceAudience;

@Deprecated
@InterfaceAudience.Private
public class MasterRegistry
extends AbstractRpcBasedConnectionRegistry {
    public static final String MASTER_REGISTRY_HEDGED_REQS_FANOUT_KEY = "hbase.client.master_registry.hedged.fanout";
    public static final String MASTER_REGISTRY_INITIAL_REFRESH_DELAY_SECS = "hbase.client.master_registry.initial_refresh_delay_secs";
    public static final String MASTER_REGISTRY_PERIODIC_REFRESH_INTERVAL_SECS = "hbase.client.master_registry.refresh_interval_secs";
    public static final String MASTER_REGISTRY_MIN_SECS_BETWEEN_REFRESHES = "hbase.client.master_registry.min_secs_between_refreshes";
    private static final String MASTER_ADDRS_CONF_SEPARATOR = ",";

    public static Set<ServerName> parseMasterAddrs(Configuration conf) throws UnknownHostException {
        HashSet<ServerName> masterAddrs = new HashSet<ServerName>();
        String configuredMasters = MasterRegistry.getMasterAddr(conf);
        for (String masterAddr : configuredMasters.split(MASTER_ADDRS_CONF_SEPARATOR)) {
            HostAndPort masterHostPort = HostAndPort.fromString(masterAddr.trim()).withDefaultPort(16000);
            masterAddrs.add(ServerName.valueOf(masterHostPort.toString(), -1L));
        }
        Preconditions.checkArgument(!masterAddrs.isEmpty(), "At least one master address is needed");
        return masterAddrs;
    }

    MasterRegistry(Configuration conf) throws IOException {
        super(conf, MASTER_REGISTRY_HEDGED_REQS_FANOUT_KEY, MASTER_REGISTRY_INITIAL_REFRESH_DELAY_SECS, MASTER_REGISTRY_PERIODIC_REFRESH_INTERVAL_SECS, MASTER_REGISTRY_MIN_SECS_BETWEEN_REFRESHES);
    }

    @Override
    protected Set<ServerName> getBootstrapNodes(Configuration conf) throws IOException {
        return MasterRegistry.parseMasterAddrs(conf);
    }

    @Override
    protected CompletableFuture<Set<ServerName>> fetchEndpoints() {
        return this.getMasters();
    }

    public static String getMasterAddr(Configuration conf) throws UnknownHostException {
        String masterAddrFromConf = conf.get("hbase.masters");
        if (!Strings.isNullOrEmpty(masterAddrFromConf)) {
            return masterAddrFromConf;
        }
        String hostname = DNS.getHostname(conf, DNS.ServerType.MASTER);
        int port = conf.getInt("hbase.master.port", 16000);
        return String.format("%s:%d", hostname, port);
    }

    private static Set<ServerName> transformServerNames(RegistryProtos.GetMastersResponse resp) {
        return resp.getMasterServersList().stream().map(s -> ProtobufUtil.toServerName(s.getServerName())).collect(Collectors.toSet());
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/(.*/MasterRegistry.java|src/test/.*)")
    CompletableFuture<Set<ServerName>> getMasters() {
        return this.call((c, s, d) -> s.getMasters(c, RegistryProtos.GetMastersRequest.getDefaultInstance(), d), r -> r.getMasterServersCount() != 0, "getMasters()").thenApply(MasterRegistry::transformServerNames);
    }
}

