/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hbase.io.DelegatingInputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BoundedDelegatingInputStream
extends DelegatingInputStream {
    protected long limit;
    protected long pos;

    public BoundedDelegatingInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit;
        this.pos = 0L;
    }

    public void setDelegate(InputStream in, long limit) {
        this.in = in;
        this.limit = limit;
        this.pos = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        int result = this.in.read();
        ++this.pos;
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        long readLen = Math.min((long)len, this.limit - this.pos);
        int read = this.in.read(b, off, (int)readLen);
        if (read < 0) {
            return -1;
        }
        this.pos += (long)read;
        return read;
    }

    @Override
    public long skip(long len) throws IOException {
        long skipped = this.in.skip(Math.min(len, this.limit - this.pos));
        this.pos += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this.pos >= this.limit) {
            return 0;
        }
        return (int)(this.limit - this.pos);
    }
}

