/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncConnectionConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncConnectionConfiguration.class);
    public static final String HBASE_CLIENT_PAUSE_FOR_SERVER_OVERLOADED = "hbase.client.pause.server.overloaded";
    public static final String START_LOG_ERRORS_AFTER_COUNT_KEY = "hbase.client.start.log.errors.counter";
    public static final int DEFAULT_START_LOG_ERRORS_AFTER_COUNT = 5;
    private final long metaOperationTimeoutNs;
    private final long operationTimeoutNs;
    private final long rpcTimeoutNs;
    private final long readRpcTimeoutNs;
    private final long writeRpcTimeoutNs;
    private final long pauseNs;
    private final long pauseNsForServerOverloaded;
    private final int maxRetries;
    private final int startLogErrorsCnt;
    private final long scanTimeoutNs;
    private final int scannerCaching;
    private final int metaScannerCaching;
    private final long scannerMaxResultSize;
    private final long writeBufferSize;
    private final long writeBufferPeriodicFlushTimeoutNs;
    private final long primaryCallTimeoutNs;
    private final long primaryScanTimeoutNs;
    private final long primaryMetaScanTimeoutNs;
    private final int maxKeyValueSize;

    AsyncConnectionConfiguration(Configuration conf) {
        this.metaOperationTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.meta.operation.timeout", 1200000L));
        this.operationTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.operation.timeout", 1200000L));
        long rpcTimeoutMs = conf.getLong("hbase.rpc.timeout", 60000L);
        this.rpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(rpcTimeoutMs);
        this.readRpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.rpc.read.timeout", rpcTimeoutMs));
        this.writeRpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.rpc.write.timeout", rpcTimeoutMs));
        long pauseMs = conf.getLong("hbase.client.pause", 100L);
        long pauseMsForServerOverloaded = conf.getLong(HBASE_CLIENT_PAUSE_FOR_SERVER_OVERLOADED, conf.getLong("hbase.client.pause.cqtbe", pauseMs));
        if (pauseMsForServerOverloaded < pauseMs) {
            LOG.warn("The {} setting: {} ms is less than the {} setting: {} ms, use the greater one instead", new Object[]{HBASE_CLIENT_PAUSE_FOR_SERVER_OVERLOADED, pauseMsForServerOverloaded, "hbase.client.pause", pauseMs});
            pauseMsForServerOverloaded = pauseMs;
        }
        this.pauseNs = TimeUnit.MILLISECONDS.toNanos(pauseMs);
        this.pauseNsForServerOverloaded = TimeUnit.MILLISECONDS.toNanos(pauseMsForServerOverloaded);
        this.maxRetries = conf.getInt("hbase.client.retries.number", 15);
        this.startLogErrorsCnt = conf.getInt(START_LOG_ERRORS_AFTER_COUNT_KEY, 5);
        this.scanTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getInt("hbase.client.scanner.timeout.period", 60000));
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.metaScannerCaching = conf.getInt("hbase.meta.scanner.caching", 100);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.writeBufferSize = conf.getLong("hbase.client.write.buffer", 0x200000L);
        this.writeBufferPeriodicFlushTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.write.buffer.periodicflush.timeout.ms", 0L));
        this.primaryCallTimeoutNs = TimeUnit.MICROSECONDS.toNanos(conf.getLong("hbase.client.primaryCallTimeout.get", 10000L));
        this.primaryScanTimeoutNs = TimeUnit.MICROSECONDS.toNanos(conf.getLong("hbase.client.replicaCallTimeout.scan", 1000000L));
        this.primaryMetaScanTimeoutNs = TimeUnit.MICROSECONDS.toNanos(conf.getLong("hbase.client.meta.replica.scan.timeout", 1000000L));
        this.maxKeyValueSize = conf.getInt("hbase.client.keyvalue.maxsize", 0xA00000);
    }

    long getMetaOperationTimeoutNs() {
        return this.metaOperationTimeoutNs;
    }

    long getOperationTimeoutNs() {
        return this.operationTimeoutNs;
    }

    long getRpcTimeoutNs() {
        return this.rpcTimeoutNs;
    }

    long getReadRpcTimeoutNs() {
        return this.readRpcTimeoutNs;
    }

    long getWriteRpcTimeoutNs() {
        return this.writeRpcTimeoutNs;
    }

    long getPauseNs() {
        return this.pauseNs;
    }

    long getPauseNsForServerOverloaded() {
        return this.pauseNsForServerOverloaded;
    }

    int getMaxRetries() {
        return this.maxRetries;
    }

    int getStartLogErrorsCnt() {
        return this.startLogErrorsCnt;
    }

    long getScanTimeoutNs() {
        return this.scanTimeoutNs;
    }

    int getScannerCaching() {
        return this.scannerCaching;
    }

    int getMetaScannerCaching() {
        return this.metaScannerCaching;
    }

    long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    long getWriteBufferPeriodicFlushTimeoutNs() {
        return this.writeBufferPeriodicFlushTimeoutNs;
    }

    long getPrimaryCallTimeoutNs() {
        return this.primaryCallTimeoutNs;
    }

    long getPrimaryScanTimeoutNs() {
        return this.primaryScanTimeoutNs;
    }

    long getPrimaryMetaScanTimeoutNs() {
        return this.primaryMetaScanTimeoutNs;
    }

    int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }

    static {
        Configuration.addDeprecation((String)"hbase.client.pause.cqtbe", (String)HBASE_CLIENT_PAUSE_FOR_SERVER_OVERLOADED);
    }
}

