/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.ipc.FallbackDisallowedException;
import org.apache.hadoop.hbase.security.NettyHBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NettyHBaseSaslRpcClientHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHBaseSaslRpcClientHandler.class);
    private final Promise<Boolean> saslPromise;
    private final UserGroupInformation ugi;
    private final NettyHBaseSaslRpcClient saslRpcClient;
    private final Configuration conf;
    private final SaslClientAuthenticationProvider provider;
    private boolean needProcessConnectionHeader = false;

    public NettyHBaseSaslRpcClientHandler(Promise<Boolean> saslPromise, UserGroupInformation ugi, SaslClientAuthenticationProvider provider, Token<? extends TokenIdentifier> token, InetAddress serverAddr, SecurityInfo securityInfo, boolean fallbackAllowed, Configuration conf) throws IOException {
        this.saslPromise = saslPromise;
        this.ugi = ugi;
        this.conf = conf;
        this.provider = provider;
        this.saslRpcClient = new NettyHBaseSaslRpcClient(conf, provider, token, serverAddr, securityInfo, fallbackAllowed, conf.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase()));
    }

    private void writeResponse(ChannelHandlerContext ctx, byte[] response) {
        LOG.trace("Sending token size={} from initSASLContext.", (Object)response.length);
        ctx.writeAndFlush(ctx.alloc().buffer(4 + response.length).writeInt(response.length).writeBytes(response));
    }

    private void tryComplete(ChannelHandlerContext ctx) {
        if (!this.saslRpcClient.isComplete()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("SASL negotiation for {} is complete", (Object)this.provider.getSaslAuthMethod().getName());
        }
        this.saslRpcClient.setupSaslHandler(ctx.pipeline());
        this.setCryptoAESOption();
        this.saslPromise.setSuccess(true);
    }

    private void setCryptoAESOption() {
        boolean saslEncryptionEnabled = SaslUtil.QualityOfProtection.PRIVACY.getSaslQop().equalsIgnoreCase(this.saslRpcClient.getSaslQOP());
        this.needProcessConnectionHeader = saslEncryptionEnabled && this.conf.getBoolean("hbase.rpc.crypto.encryption.aes.enabled", false);
    }

    public boolean isNeedProcessConnectionHeader() {
        return this.needProcessConnectionHeader;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        try {
            byte[] initialResponse = (byte[])this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return NettyHBaseSaslRpcClientHandler.this.saslRpcClient.getInitialResponse();
                }
            });
            assert (initialResponse != null);
            this.writeResponse(ctx, initialResponse);
        }
        catch (Exception e) {
            this.exceptionCaught(ctx, e);
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        int len = msg.readInt();
        if (len == -88) {
            this.saslRpcClient.dispose();
            if (this.saslRpcClient.fallbackAllowed) {
                this.saslPromise.trySuccess(false);
            } else {
                this.saslPromise.tryFailure(new FallbackDisallowedException());
            }
            return;
        }
        LOG.trace("Reading input token size={} for processing by initSASLContext", (Object)len);
        final byte[] challenge = new byte[len];
        msg.readBytes(challenge);
        byte[] response = (byte[])this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return NettyHBaseSaslRpcClientHandler.this.saslRpcClient.evaluateChallenge(challenge);
            }
        });
        if (response != null) {
            this.writeResponse(ctx, response);
        } else {
            LOG.trace("SASL challenge response was empty, not sending response to server.");
        }
        this.tryComplete(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.saslRpcClient.dispose();
        this.saslPromise.tryFailure(new ConnectionClosedException("Connection closed"));
        ctx.fireChannelInactive();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.saslRpcClient.dispose();
        this.saslPromise.tryFailure(cause);
    }
}

