/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterListBase;
import org.apache.hadoop.hbase.filter.FilterListWithAND;
import org.apache.hadoop.hbase.filter.FilterListWithOR;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class FilterList
extends FilterBase {
    private Operator operator;
    private FilterListBase filterListBase;

    public FilterList(Operator operator, List<Filter> filters) {
        if (operator == Operator.MUST_PASS_ALL) {
            this.filterListBase = new FilterListWithAND(filters);
        } else if (operator == Operator.MUST_PASS_ONE) {
            this.filterListBase = new FilterListWithOR(filters);
        } else {
            throw new IllegalArgumentException("Invalid operator: " + (Object)((Object)operator));
        }
        this.operator = operator;
    }

    public FilterList(List<Filter> filters) {
        this(Operator.MUST_PASS_ALL, filters);
    }

    public FilterList(Filter ... filters) {
        this(Operator.MUST_PASS_ALL, Arrays.asList(filters));
    }

    public FilterList(Operator operator) {
        this(operator, new ArrayList<Filter>());
    }

    public FilterList(Operator operator, Filter ... filters) {
        this(operator, Arrays.asList(filters));
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Filter> getFilters() {
        return this.filterListBase.getFilters();
    }

    public int size() {
        return this.filterListBase.size();
    }

    public void addFilter(List<Filter> filters) {
        this.filterListBase.addFilterLists(filters);
    }

    public void addFilter(Filter filter) {
        this.addFilter(Collections.singletonList(filter));
    }

    @Override
    public void reset() throws IOException {
        this.filterListBase.reset();
    }

    @Override
    public boolean filterRowKey(Cell firstRowCell) throws IOException {
        return this.filterListBase.filterRowKey(firstRowCell);
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        return this.filterListBase.filterAllRemaining();
    }

    @Override
    public Cell transformCell(Cell c) throws IOException {
        return this.filterListBase.transformCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        return this.filterListBase.filterCell(c);
    }

    @Override
    public void filterRowCells(List<Cell> cells) throws IOException {
        this.filterListBase.filterRowCells(cells);
    }

    @Override
    public boolean hasFilterRow() {
        return this.filterListBase.hasFilterRow();
    }

    @Override
    public boolean filterRow() throws IOException {
        return this.filterListBase.filterRow();
    }

    @Override
    public byte[] toByteArray() throws IOException {
        FilterProtos.FilterList.Builder builder = FilterProtos.FilterList.newBuilder();
        builder.setOperator(FilterProtos.FilterList.Operator.valueOf(this.operator.name()));
        ArrayList<Filter> filters = this.filterListBase.getFilters();
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            builder.addFilters(ProtobufUtil.toFilter(filters.get(i)));
        }
        return builder.build().toByteArray();
    }

    public static FilterList parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FilterList proto;
        try {
            proto = FilterProtos.FilterList.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        ArrayList<Filter> rowFilters = new ArrayList<Filter>(proto.getFiltersCount());
        try {
            List<FilterProtos.Filter> filtersList = proto.getFiltersList();
            int n = filtersList.size();
            for (int i = 0; i < n; ++i) {
                rowFilters.add(ProtobufUtil.toFilter(filtersList.get(i)));
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new FilterList(Operator.valueOf(proto.getOperator().name()), rowFilters);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FilterList)) {
            return false;
        }
        FilterList o = (FilterList)other;
        return this.getOperator().equals((Object)o.getOperator()) && (this.getFilters() == o.getFilters() || this.getFilters().equals(o.getFilters()));
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) throws IOException {
        return this.filterListBase.getNextCellHint(currentCell);
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        return this.filterListBase.isFamilyEssential(name);
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
        this.filterListBase.setReversed(reversed);
    }

    @Override
    public boolean isReversed() {
        assert (this.reversed == this.filterListBase.isReversed());
        return this.reversed;
    }

    @Override
    public String toString() {
        return this.filterListBase.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getOperator(), this.getFilters()});
    }

    @InterfaceAudience.Public
    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

