/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni.ast;

import org.apache.hadoop.hbase.shaded.org.joni.ScanEnvironment;
import org.apache.hadoop.hbase.shaded.org.joni.ast.Node;
import org.apache.hadoop.hbase.shaded.org.joni.ast.StateNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.StringNode;

public final class QuantifierNode
extends StateNode {
    public static final int REPEAT_INFINITE = -1;
    public Node target;
    public int lower;
    public int upper;
    public boolean greedy;
    public int targetEmptyInfo;
    public Node headExact;
    public Node nextHeadExact;
    public boolean isRefered;
    public int combExpCheckNum;
    static final ReduceType[][] REDUCE_TABLE = new ReduceType[][]{{ReduceType.DEL, ReduceType.A, ReduceType.A, ReduceType.QQ, ReduceType.AQ, ReduceType.ASIS}, {ReduceType.DEL, ReduceType.DEL, ReduceType.DEL, ReduceType.P_QQ, ReduceType.P_QQ, ReduceType.DEL}, {ReduceType.A, ReduceType.A, ReduceType.DEL, ReduceType.ASIS, ReduceType.P_QQ, ReduceType.DEL}, {ReduceType.DEL, ReduceType.AQ, ReduceType.AQ, ReduceType.DEL, ReduceType.AQ, ReduceType.AQ}, {ReduceType.DEL, ReduceType.DEL, ReduceType.DEL, ReduceType.DEL, ReduceType.DEL, ReduceType.DEL}, {ReduceType.ASIS, ReduceType.ASIS, ReduceType.ASIS, ReduceType.AQ, ReduceType.AQ, ReduceType.DEL}};
    static final String[] PopularQStr = new String[]{"?", "*", "+", "??", "*?", "+?"};
    static final String[] ReduceQStr = new String[]{"", "", "*", "*?", "??", "+ and ??", "+? and ?"};

    public QuantifierNode(int lower, int upper, boolean byNumber) {
        super(5);
        this.lower = lower;
        this.upper = upper;
        this.greedy = true;
        this.targetEmptyInfo = 0;
        if (byNumber) {
            this.setByNumber();
        }
    }

    @Override
    protected void setChild(Node child) {
        this.target = child;
    }

    @Override
    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node tgt) {
        this.target = tgt;
        tgt.parent = this;
    }

    @Override
    public String getName() {
        return "Quantifier";
    }

    @Override
    public String toString(int level) {
        StringBuilder value = new StringBuilder(super.toString(level));
        value.append("\n  lower: " + this.lower);
        value.append(", upper: " + this.upper);
        value.append(", greedy: " + this.greedy);
        value.append(", isRefered: " + this.isRefered);
        value.append(", targetEmptyInfo: " + this.targetEmptyInfo);
        value.append(", combExpCheckNum: " + this.combExpCheckNum);
        value.append("\n  headExact: " + QuantifierNode.pad(this.headExact, level + 1));
        value.append("\n  nextHeadExact: " + QuantifierNode.pad(this.nextHeadExact, level + 1));
        value.append("\n  target: " + QuantifierNode.pad(this.target, level + 1));
        return value.toString();
    }

    public boolean isAnyCharStar() {
        return this.greedy && QuantifierNode.isRepeatInfinite(this.upper) && this.target.getType() == 3;
    }

    protected int popularNum() {
        if (this.greedy) {
            if (this.lower == 0) {
                if (this.upper == 1) {
                    return 0;
                }
                if (QuantifierNode.isRepeatInfinite(this.upper)) {
                    return 1;
                }
            } else if (this.lower == 1 && QuantifierNode.isRepeatInfinite(this.upper)) {
                return 2;
            }
        } else if (this.lower == 0) {
            if (this.upper == 1) {
                return 3;
            }
            if (QuantifierNode.isRepeatInfinite(this.upper)) {
                return 4;
            }
        } else if (this.lower == 1 && QuantifierNode.isRepeatInfinite(this.upper)) {
            return 5;
        }
        return -1;
    }

    protected void copy(QuantifierNode other) {
        this.state = other.state;
        this.setTarget(other.target);
        other.target = null;
        this.lower = other.lower;
        this.upper = other.upper;
        this.greedy = other.greedy;
        this.targetEmptyInfo = other.targetEmptyInfo;
        this.headExact = other.headExact;
        this.nextHeadExact = other.nextHeadExact;
        this.isRefered = other.isRefered;
        this.combExpCheckNum = other.combExpCheckNum;
    }

    public void reduceNestedQuantifier(QuantifierNode other) {
        int pnum = this.popularNum();
        int cnum = other.popularNum();
        if (pnum < 0 || cnum < 0) {
            return;
        }
        switch (REDUCE_TABLE[cnum][pnum]) {
            case DEL: {
                this.copy(other);
                break;
            }
            case A: {
                this.setTarget(other.target);
                this.lower = 0;
                this.upper = -1;
                this.greedy = true;
                break;
            }
            case AQ: {
                this.setTarget(other.target);
                this.lower = 0;
                this.upper = -1;
                this.greedy = false;
                break;
            }
            case QQ: {
                this.setTarget(other.target);
                this.lower = 0;
                this.upper = 1;
                this.greedy = false;
                break;
            }
            case P_QQ: {
                this.setTarget(other);
                this.lower = 0;
                this.upper = 1;
                this.greedy = false;
                other.lower = 1;
                other.upper = -1;
                other.greedy = true;
                return;
            }
            case ASIS: {
                this.setTarget(other);
                return;
            }
        }
        other.target = null;
    }

    public int setQuantifier(Node tgt, boolean group, ScanEnvironment env, byte[] bytes, int p, int end) {
        if (this.lower == 1 && this.upper == 1) {
            if (env.syntax.op3OptionECMAScript()) {
                this.setTarget(tgt);
            }
            return 1;
        }
        switch (tgt.getType()) {
            case 0: {
                StringNode n;
                StringNode sn;
                if (group || !(sn = (StringNode)tgt).canBeSplit(env.enc) || (n = sn.splitLastChar(env.enc)) == null) break;
                this.setTarget(n);
                return 2;
            }
            case 5: {
                QuantifierNode qnt = (QuantifierNode)tgt;
                int nestQNum = this.popularNum();
                int targetQNum = qnt.popularNum();
                if (nestQNum >= 0 && targetQNum >= 0 && env.syntax.warnReduntantNestedRepeat()) {
                    switch (REDUCE_TABLE[targetQNum][nestQNum]) {
                        case ASIS: {
                            break;
                        }
                        case DEL: {
                            env.warnings.warn("regular expression has redundant nested repeat operator " + PopularQStr[targetQNum] + " /" + new String(bytes, p, end) + "/");
                            break;
                        }
                        default: {
                            env.warnings.warn("nested repeat operator '" + PopularQStr[targetQNum] + "' and '" + PopularQStr[nestQNum] + "' was replaced with '" + ReduceQStr[REDUCE_TABLE[targetQNum][nestQNum].ordinal()] + "' in regular expression /" + new String(bytes, p, end) + "/");
                        }
                    }
                }
                if (targetQNum < 0) break;
                if (nestQNum >= 0) {
                    this.reduceNestedQuantifier(qnt);
                    return 0;
                }
                if (targetQNum != 1 && targetQNum != 2 || QuantifierNode.isRepeatInfinite(this.upper) || this.upper <= 1 || !this.greedy) break;
                this.upper = this.lower == 0 ? 1 : this.lower;
            }
        }
        this.setTarget(tgt);
        return 0;
    }

    public static boolean isRepeatInfinite(int n) {
        return n == -1;
    }

    static enum ReduceType {
        ASIS,
        DEL,
        A,
        AQ,
        QQ,
        P_QQ;

    }
}

