/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ServerTask;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.UserMetrics;
import org.apache.hadoop.hbase.UserMetricsBuilder;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ServerMetricsBuilder {
    private final ServerName serverName;
    private int versionNumber;
    private String version = "0.0.0";
    private long requestCountPerSecond;
    private long requestCount;
    private long readRequestCount;
    private long writeRequestCount;
    private Size usedHeapSize = Size.ZERO;
    private Size maxHeapSize = Size.ZERO;
    private int infoServerPort;
    private List<ReplicationLoadSource> sources = Collections.emptyList();
    @Nullable
    private ReplicationLoadSink sink = null;
    private final Map<byte[], RegionMetrics> regionStatus = new TreeMap<byte[], RegionMetrics>(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], UserMetrics> userMetrics = new TreeMap<byte[], UserMetrics>(Bytes.BYTES_COMPARATOR);
    private final Set<String> coprocessorNames = new TreeSet<String>();
    private long reportTimestamp = EnvironmentEdgeManager.currentTime();
    private long lastReportTimestamp = 0L;
    private final List<ServerTask> tasks = new ArrayList<ServerTask>();
    private Map<String, Integer> regionCachedInfo = new HashMap<String, Integer>();

    public static ServerMetrics of(ServerName sn) {
        return ServerMetricsBuilder.newBuilder(sn).build();
    }

    public static ServerMetrics of(ServerName sn, int versionNumber, String version) {
        return ServerMetricsBuilder.newBuilder(sn).setVersionNumber(versionNumber).setVersion(version).build();
    }

    public static ServerMetrics toServerMetrics(ClusterStatusProtos.LiveServerInfo serverInfo) {
        return ServerMetricsBuilder.toServerMetrics(ProtobufUtil.toServerName(serverInfo.getServer()), 0, "0.0.0", serverInfo.getServerLoad());
    }

    public static ServerMetrics toServerMetrics(ServerName serverName, ClusterStatusProtos.ServerLoad serverLoadPB) {
        return ServerMetricsBuilder.toServerMetrics(serverName, 0, "0.0.0", serverLoadPB);
    }

    public static ServerMetrics toServerMetrics(ServerName serverName, int versionNumber, String version, ClusterStatusProtos.ServerLoad serverLoadPB) {
        return ServerMetricsBuilder.newBuilder(serverName).setRequestCountPerSecond(serverLoadPB.getNumberOfRequests()).setRequestCount(serverLoadPB.getTotalNumberOfRequests()).setInfoServerPort(serverLoadPB.getInfoServerPort()).setReadRequestCount(serverLoadPB.getReadRequestsCount()).setWriteRequestCount(serverLoadPB.getWriteRequestsCount()).setMaxHeapSize(new Size(serverLoadPB.getMaxHeapMB(), Size.Unit.MEGABYTE)).setUsedHeapSize(new Size(serverLoadPB.getUsedHeapMB(), Size.Unit.MEGABYTE)).setCoprocessorNames(serverLoadPB.getCoprocessorsList().stream().map(HBaseProtos.Coprocessor::getName).collect(Collectors.toList())).setRegionMetrics(serverLoadPB.getRegionLoadsList().stream().map(RegionMetricsBuilder::toRegionMetrics).collect(Collectors.toList())).setUserMetrics(serverLoadPB.getUserLoadsList().stream().map(UserMetricsBuilder::toUserMetrics).collect(Collectors.toList())).setReplicationLoadSources(serverLoadPB.getReplLoadSourceList().stream().map(ProtobufUtil::toReplicationLoadSource).collect(Collectors.toList())).setReplicationLoadSink(serverLoadPB.hasReplLoadSink() ? ProtobufUtil.toReplicationLoadSink(serverLoadPB.getReplLoadSink()) : null).setTasks(serverLoadPB.getTasksList().stream().map(ProtobufUtil::getServerTask).collect(Collectors.toList())).setRegionCachedInfo(serverLoadPB.getRegionCachedInfoMap()).setReportTimestamp(serverLoadPB.getReportEndTime()).setLastReportTimestamp(serverLoadPB.getReportStartTime()).setVersionNumber(versionNumber).setVersion(version).build();
    }

    public static List<HBaseProtos.Coprocessor> toCoprocessor(Collection<String> names) {
        return names.stream().map(n -> HBaseProtos.Coprocessor.newBuilder().setName((String)n).build()).collect(Collectors.toList());
    }

    public static ClusterStatusProtos.ServerLoad toServerLoad(ServerMetrics metrics) {
        ClusterStatusProtos.ServerLoad.Builder builder = ClusterStatusProtos.ServerLoad.newBuilder().setNumberOfRequests(metrics.getRequestCountPerSecond()).setTotalNumberOfRequests(metrics.getRequestCount()).setInfoServerPort(metrics.getInfoServerPort()).setMaxHeapMB((int)metrics.getMaxHeapSize().get(Size.Unit.MEGABYTE)).setUsedHeapMB((int)metrics.getUsedHeapSize().get(Size.Unit.MEGABYTE)).addAllCoprocessors(ServerMetricsBuilder.toCoprocessor(metrics.getCoprocessorNames())).addAllRegionLoads(metrics.getRegionMetrics().values().stream().map(RegionMetricsBuilder::toRegionLoad).collect(Collectors.toList())).addAllUserLoads(metrics.getUserMetrics().values().stream().map(UserMetricsBuilder::toUserMetrics).collect(Collectors.toList())).addAllReplLoadSource(metrics.getReplicationLoadSourceList().stream().map(ProtobufUtil::toReplicationLoadSource).collect(Collectors.toList())).addAllTasks(metrics.getTasks().stream().map(ProtobufUtil::toServerTask).collect(Collectors.toList())).putAllRegionCachedInfo(metrics.getRegionCachedInfo()).setReportStartTime(metrics.getLastReportTimestamp()).setReportEndTime(metrics.getReportTimestamp());
        if (metrics.getReplicationLoadSink() != null) {
            builder.setReplLoadSink(ProtobufUtil.toReplicationLoadSink(metrics.getReplicationLoadSink()));
        }
        return builder.build();
    }

    public static ServerMetricsBuilder newBuilder(ServerName sn) {
        return new ServerMetricsBuilder(sn);
    }

    private ServerMetricsBuilder(ServerName serverName) {
        this.serverName = serverName;
    }

    public ServerMetricsBuilder setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    public ServerMetricsBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public ServerMetricsBuilder setRequestCountPerSecond(long value) {
        this.requestCountPerSecond = value;
        return this;
    }

    public ServerMetricsBuilder setRequestCount(long value) {
        this.requestCount = value;
        return this;
    }

    public ServerMetricsBuilder setReadRequestCount(long value) {
        this.readRequestCount = value;
        return this;
    }

    public ServerMetricsBuilder setWriteRequestCount(long value) {
        this.writeRequestCount = value;
        return this;
    }

    public ServerMetricsBuilder setUsedHeapSize(Size value) {
        this.usedHeapSize = value;
        return this;
    }

    public ServerMetricsBuilder setMaxHeapSize(Size value) {
        this.maxHeapSize = value;
        return this;
    }

    public ServerMetricsBuilder setInfoServerPort(int value) {
        this.infoServerPort = value;
        return this;
    }

    public ServerMetricsBuilder setReplicationLoadSources(List<ReplicationLoadSource> value) {
        this.sources = value;
        return this;
    }

    public ServerMetricsBuilder setReplicationLoadSink(ReplicationLoadSink value) {
        this.sink = value;
        return this;
    }

    public ServerMetricsBuilder setRegionMetrics(List<RegionMetrics> value) {
        value.forEach(v -> this.regionStatus.put(v.getRegionName(), (RegionMetrics)v));
        return this;
    }

    public ServerMetricsBuilder setUserMetrics(List<UserMetrics> value) {
        value.forEach(v -> this.userMetrics.put(v.getUserName(), (UserMetrics)v));
        return this;
    }

    public ServerMetricsBuilder setCoprocessorNames(List<String> value) {
        this.coprocessorNames.addAll(value);
        return this;
    }

    public ServerMetricsBuilder setReportTimestamp(long value) {
        this.reportTimestamp = value;
        return this;
    }

    public ServerMetricsBuilder setLastReportTimestamp(long value) {
        this.lastReportTimestamp = value;
        return this;
    }

    public ServerMetricsBuilder setTasks(List<ServerTask> tasks) {
        this.tasks.addAll(tasks);
        return this;
    }

    public ServerMetricsBuilder setRegionCachedInfo(Map<String, Integer> value) {
        this.regionCachedInfo = value;
        return this;
    }

    public ServerMetrics build() {
        return new ServerMetricsImpl(this.serverName, this.versionNumber, this.version, this.requestCountPerSecond, this.requestCount, this.readRequestCount, this.writeRequestCount, this.usedHeapSize, this.maxHeapSize, this.infoServerPort, this.sources, this.sink, this.regionStatus, this.coprocessorNames, this.reportTimestamp, this.lastReportTimestamp, this.userMetrics, this.tasks, this.regionCachedInfo);
    }

    private static class ServerMetricsImpl
    implements ServerMetrics {
        private final ServerName serverName;
        private final int versionNumber;
        private final String version;
        private final long requestCountPerSecond;
        private final long requestCount;
        private final long readRequestsCount;
        private final long writeRequestsCount;
        private final Size usedHeapSize;
        private final Size maxHeapSize;
        private final int infoServerPort;
        private final List<ReplicationLoadSource> sources;
        @Nullable
        private final ReplicationLoadSink sink;
        private final Map<byte[], RegionMetrics> regionStatus;
        private final Set<String> coprocessorNames;
        private final long reportTimestamp;
        private final long lastReportTimestamp;
        private final Map<byte[], UserMetrics> userMetrics;
        private final List<ServerTask> tasks;
        private final Map<String, Integer> regionCachedInfo;

        ServerMetricsImpl(ServerName serverName, int versionNumber, String version, long requestCountPerSecond, long requestCount, long readRequestsCount, long writeRequestsCount, Size usedHeapSize, Size maxHeapSize, int infoServerPort, List<ReplicationLoadSource> sources, ReplicationLoadSink sink, Map<byte[], RegionMetrics> regionStatus, Set<String> coprocessorNames, long reportTimestamp, long lastReportTimestamp, Map<byte[], UserMetrics> userMetrics, List<ServerTask> tasks, Map<String, Integer> regionCachedInfo) {
            this.serverName = Preconditions.checkNotNull(serverName);
            this.versionNumber = versionNumber;
            this.version = version;
            this.requestCountPerSecond = requestCountPerSecond;
            this.requestCount = requestCount;
            this.readRequestsCount = readRequestsCount;
            this.writeRequestsCount = writeRequestsCount;
            this.usedHeapSize = Preconditions.checkNotNull(usedHeapSize);
            this.maxHeapSize = Preconditions.checkNotNull(maxHeapSize);
            this.infoServerPort = infoServerPort;
            this.sources = Preconditions.checkNotNull(sources);
            this.sink = sink;
            this.regionStatus = Preconditions.checkNotNull(regionStatus);
            this.userMetrics = Preconditions.checkNotNull(userMetrics);
            this.coprocessorNames = Preconditions.checkNotNull(coprocessorNames);
            this.reportTimestamp = reportTimestamp;
            this.lastReportTimestamp = lastReportTimestamp;
            this.tasks = tasks;
            this.regionCachedInfo = regionCachedInfo;
        }

        @Override
        public ServerName getServerName() {
            return this.serverName;
        }

        @Override
        public int getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public long getRequestCountPerSecond() {
            return this.requestCountPerSecond;
        }

        @Override
        public long getRequestCount() {
            return this.requestCount;
        }

        @Override
        public long getReadRequestsCount() {
            return this.readRequestsCount;
        }

        @Override
        public long getWriteRequestsCount() {
            return this.writeRequestsCount;
        }

        @Override
        public Size getUsedHeapSize() {
            return this.usedHeapSize;
        }

        @Override
        public Size getMaxHeapSize() {
            return this.maxHeapSize;
        }

        @Override
        public int getInfoServerPort() {
            return this.infoServerPort;
        }

        @Override
        public List<ReplicationLoadSource> getReplicationLoadSourceList() {
            return Collections.unmodifiableList(this.sources);
        }

        @Override
        public Map<String, List<ReplicationLoadSource>> getReplicationLoadSourceMap() {
            HashMap<String, List<ReplicationLoadSource>> sourcesMap = new HashMap<String, List<ReplicationLoadSource>>();
            for (ReplicationLoadSource loadSource : this.sources) {
                sourcesMap.computeIfAbsent(loadSource.getPeerID(), peerId -> new ArrayList()).add(loadSource);
            }
            return sourcesMap;
        }

        @Override
        public ReplicationLoadSink getReplicationLoadSink() {
            return this.sink;
        }

        @Override
        public Map<byte[], RegionMetrics> getRegionMetrics() {
            return Collections.unmodifiableMap(this.regionStatus);
        }

        @Override
        public Map<byte[], UserMetrics> getUserMetrics() {
            return Collections.unmodifiableMap(this.userMetrics);
        }

        @Override
        public Set<String> getCoprocessorNames() {
            return Collections.unmodifiableSet(this.coprocessorNames);
        }

        @Override
        public long getReportTimestamp() {
            return this.reportTimestamp;
        }

        @Override
        public long getLastReportTimestamp() {
            return this.lastReportTimestamp;
        }

        @Override
        public List<ServerTask> getTasks() {
            return this.tasks;
        }

        @Override
        public Map<String, Integer> getRegionCachedInfo() {
            return Collections.unmodifiableMap(this.regionCachedInfo);
        }

        public String toString() {
            int storeCount = 0;
            int storeFileCount = 0;
            int storeRefCount = 0;
            int maxCompactedStoreFileRefCount = 0;
            long uncompressedStoreFileSizeMB = 0L;
            long storeFileSizeMB = 0L;
            long memStoreSizeMB = 0L;
            long storefileIndexSizeKB = 0L;
            long rootLevelIndexSizeKB = 0L;
            long readRequestsCount = 0L;
            long cpRequestsCount = 0L;
            long writeRequestsCount = 0L;
            long filteredReadRequestsCount = 0L;
            long bloomFilterSizeMB = 0L;
            long compactingCellCount = 0L;
            long compactedCellCount = 0L;
            for (RegionMetrics r : this.getRegionMetrics().values()) {
                storeCount += r.getStoreCount();
                storeFileCount += r.getStoreFileCount();
                storeRefCount += r.getStoreRefCount();
                int currentMaxCompactedStoreFileRefCount = r.getMaxCompactedStoreFileRefCount();
                maxCompactedStoreFileRefCount = Math.max(maxCompactedStoreFileRefCount, currentMaxCompactedStoreFileRefCount);
                uncompressedStoreFileSizeMB += (long)r.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
                storeFileSizeMB += (long)r.getStoreFileSize().get(Size.Unit.MEGABYTE);
                memStoreSizeMB += (long)r.getMemStoreSize().get(Size.Unit.MEGABYTE);
                storefileIndexSizeKB += (long)r.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
                readRequestsCount += r.getReadRequestCount();
                cpRequestsCount += r.getCpRequestCount();
                writeRequestsCount += r.getWriteRequestCount();
                filteredReadRequestsCount += r.getFilteredReadRequestCount();
                rootLevelIndexSizeKB += (long)r.getStoreFileRootLevelIndexSize().get(Size.Unit.KILOBYTE);
                bloomFilterSizeMB += (long)r.getBloomFilterSize().get(Size.Unit.MEGABYTE);
                compactedCellCount += r.getCompactedCellCount();
                compactingCellCount += r.getCompactingCellCount();
            }
            StringBuilder sb = Strings.appendKeyValue(new StringBuilder(), "requestsPerSecond", this.getRequestCountPerSecond());
            Strings.appendKeyValue(sb, "numberOfOnlineRegions", this.getRegionMetrics().size());
            Strings.appendKeyValue(sb, "usedHeapMB", this.getUsedHeapSize());
            Strings.appendKeyValue(sb, "maxHeapMB", this.getMaxHeapSize());
            Strings.appendKeyValue(sb, "numberOfStores", storeCount);
            Strings.appendKeyValue(sb, "numberOfStorefiles", storeFileCount);
            Strings.appendKeyValue(sb, "storeRefCount", storeRefCount);
            Strings.appendKeyValue(sb, "maxCompactedStoreFileRefCount", maxCompactedStoreFileRefCount);
            Strings.appendKeyValue(sb, "storefileUncompressedSizeMB", uncompressedStoreFileSizeMB);
            Strings.appendKeyValue(sb, "storefileSizeMB", storeFileSizeMB);
            if (uncompressedStoreFileSizeMB != 0L) {
                Strings.appendKeyValue(sb, "compressionRatio", String.format("%.4f", Float.valueOf((float)storeFileSizeMB / (float)uncompressedStoreFileSizeMB)));
            }
            Strings.appendKeyValue(sb, "memstoreSizeMB", memStoreSizeMB);
            Strings.appendKeyValue(sb, "readRequestsCount", readRequestsCount);
            Strings.appendKeyValue(sb, "cpRequestsCount", cpRequestsCount);
            Strings.appendKeyValue(sb, "filteredReadRequestsCount", filteredReadRequestsCount);
            Strings.appendKeyValue(sb, "writeRequestsCount", writeRequestsCount);
            Strings.appendKeyValue(sb, "rootIndexSizeKB", rootLevelIndexSizeKB);
            Strings.appendKeyValue(sb, "totalStaticIndexSizeKB", storefileIndexSizeKB);
            Strings.appendKeyValue(sb, "totalStaticBloomSizeKB", bloomFilterSizeMB);
            Strings.appendKeyValue(sb, "totalCompactingKVs", compactingCellCount);
            Strings.appendKeyValue(sb, "currentCompactedKVs", compactedCellCount);
            float compactionProgressPct = Float.NaN;
            if (compactingCellCount > 0L) {
                compactionProgressPct = Float.valueOf((float)compactedCellCount / (float)compactingCellCount).floatValue();
            }
            Strings.appendKeyValue(sb, "compactionProgressPct", Float.valueOf(compactionProgressPct));
            Strings.appendKeyValue(sb, "coprocessors", this.getCoprocessorNames());
            return sb.toString();
        }
    }
}

