/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public final class RpcClientFactory {
    public static final String CUSTOM_RPC_CLIENT_IMPL_CONF_KEY = "hbase.rpc.client.impl";

    private RpcClientFactory() {
    }

    public static RpcClient createClient(Configuration conf, String clusterId) {
        return RpcClientFactory.createClient(conf, clusterId, null);
    }

    public static RpcClient createClient(Configuration conf, String clusterId, SocketAddress localAddr) {
        String rpcClientClass = conf.get(CUSTOM_RPC_CLIENT_IMPL_CONF_KEY, RpcClientImpl.class.getName());
        return (RpcClient)ReflectionUtils.instantiateWithCustomCtor(rpcClientClass, new Class[]{Configuration.class, String.class, SocketAddress.class}, new Object[]{conf, clusterId, localAddr});
    }
}

