/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;

@InterfaceAudience.Private
public class TimeLimitedRpcController
implements RpcController {
    protected volatile Integer callTimeout;
    protected volatile boolean cancelled = false;
    protected final AtomicReference<RpcCallback<Object>> cancellationCb = new AtomicReference<Object>(null);
    protected final AtomicReference<RpcCallback<IOException>> failureCb = new AtomicReference<Object>(null);
    private IOException exception;

    public int getCallTimeout() {
        if (this.callTimeout != null) {
            return this.callTimeout;
        }
        return 0;
    }

    public void setCallTimeout(int callTimeout) {
        this.callTimeout = callTimeout;
    }

    public boolean hasCallTimeout() {
        return this.callTimeout != null;
    }

    @Override
    public String errorText() {
        if (this.exception != null) {
            return this.exception.getMessage();
        }
        return null;
    }

    @Override
    public boolean failed() {
        return this.exception != null;
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    @Override
    public void notifyOnCancel(RpcCallback<Object> cancellationCb) {
        this.cancellationCb.set(cancellationCb);
        if (this.cancelled) {
            cancellationCb.run(null);
        }
    }

    public void notifyOnFail(RpcCallback<IOException> failureCb) {
        this.failureCb.set(failureCb);
        if (this.exception != null) {
            failureCb.run(this.exception);
        }
    }

    @Override
    public void reset() {
        this.exception = null;
        this.cancelled = false;
        this.failureCb.set(null);
        this.cancellationCb.set(null);
        this.callTimeout = null;
    }

    @Override
    public void setFailed(String reason) {
        this.exception = new IOException(reason);
        if (this.failureCb.get() != null) {
            this.failureCb.get().run(this.exception);
        }
    }

    public void setFailed(IOException e) {
        this.exception = e;
        if (this.failureCb.get() != null) {
            this.failureCb.get().run(this.exception);
        }
    }

    @Override
    public void startCancel() {
        this.cancelled = true;
        if (this.cancellationCb.get() != null) {
            this.cancellationCb.get().run(null);
        }
    }
}

