/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class ResourceOptionPBImpl
extends ResourceOption {
    YarnProtos.ResourceOptionProto proto = null;
    YarnProtos.ResourceOptionProto.Builder builder = null;
    private Resource resource = null;

    public ResourceOptionPBImpl() {
        this.builder = YarnProtos.ResourceOptionProto.newBuilder();
    }

    public ResourceOptionPBImpl(YarnProtos.ResourceOptionProto proto) {
        this.proto = proto;
        this.resource = this.convertFromProtoFormat(proto.getResource());
    }

    public YarnProtos.ResourceOptionProto getProto() {
        return this.proto;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    protected void setResource(Resource resource) {
        if (resource != null) {
            Preconditions.checkNotNull(this.builder);
            this.builder.setResource(this.convertToProtoFormat(resource));
        }
        this.resource = resource;
    }

    @Override
    public int getOverCommitTimeout() {
        Preconditions.checkNotNull(this.proto);
        return this.proto.getOverCommitTimeout();
    }

    @Override
    protected void setOverCommitTimeout(int overCommitTimeout) {
        Preconditions.checkNotNull(this.builder);
        this.builder.setOverCommitTimeout(overCommitTimeout);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource resource) {
        return ((ResourcePBImpl)resource).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    @Override
    protected void build() {
        this.proto = this.builder.build();
        this.builder = null;
    }
}

