/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BufferedMutatorImpl
implements BufferedMutator {
    private static final Log LOG = LogFactory.getLog(BufferedMutatorImpl.class);
    private final BufferedMutator.ExceptionListener listener;
    protected ClusterConnection connection;
    private final TableName tableName;
    private volatile Configuration conf;
    private List<Row> writeAsyncBuffer = new LinkedList<Row>();
    private long writeBufferSize;
    private final int maxKeyValueSize;
    protected long currentWriteBufferSize = 0L;
    private boolean closed = false;
    private final ExecutorService pool;
    protected AsyncProcess ap;

    BufferedMutatorImpl(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params) {
        if (conn == null || conn.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = params.getTableName();
        this.connection = conn;
        this.conf = this.connection.getConfiguration();
        this.pool = params.getPool();
        this.listener = params.getListener();
        ConnectionConfiguration tableConf = new ConnectionConfiguration(this.conf);
        this.writeBufferSize = params.getWriteBufferSize() != -1L ? params.getWriteBufferSize() : tableConf.getWriteBufferSize();
        this.maxKeyValueSize = params.getMaxKeyValueSize() != -1 ? params.getMaxKeyValueSize() : tableConf.getMaxKeyValueSize();
        this.ap = new AsyncProcess(this.connection, this.conf, this.pool, rpcCallerFactory, true, rpcFactory);
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public synchronized void mutate(Mutation m) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.doMutate(m);
    }

    @Override
    public synchronized void mutate(List<? extends Mutation> ms) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        for (Mutation mutation : ms) {
            this.doMutate(mutation);
        }
    }

    private void doMutate(Mutation m) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.closed) {
            throw new IllegalStateException("Cannot put when the BufferedMutator is closed.");
        }
        if (!(m instanceof Put) && !(m instanceof Delete)) {
            throw new IllegalArgumentException("Pass a Delete or a Put");
        }
        if (this.ap.hasError()) {
            this.writeAsyncBuffer.add(m);
            this.backgroundFlushCommits(true);
        }
        if (m instanceof Put) {
            this.validatePut((Put)m);
        }
        this.currentWriteBufferSize += m.heapSize();
        this.writeAsyncBuffer.add(m);
        while (this.currentWriteBufferSize > this.writeBufferSize) {
            this.backgroundFlushCommits(false);
        }
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        HTable.validatePut(put, this.maxKeyValueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.backgroundFlushCommits(true);
            this.pool.shutdown();
            boolean terminated = false;
            int loopCnt = 0;
            do {
                terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS);
                if (++loopCnt < 10) continue;
                LOG.warn((Object)"close() failed to terminate pool after 10 minutes. Abandoning pool.");
                break;
            } while (!terminated);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"waitForTermination interrupted");
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public synchronized void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.backgroundFlushCommits(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundFlushCommits(boolean synchronous) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        try {
            if (!synchronous) {
                this.ap.submit(this.tableName, this.writeAsyncBuffer, true, null, false);
                if (this.ap.hasError()) {
                    LOG.debug((Object)(this.tableName + ": One or more of the operations have failed -" + " waiting for all operation in progress to finish (successfully or not)"));
                }
            }
            if (synchronous || this.ap.hasError()) {
                while (!this.writeAsyncBuffer.isEmpty()) {
                    this.ap.submit(this.tableName, this.writeAsyncBuffer, true, null, false);
                }
                RetriesExhaustedWithDetailsException error = this.ap.waitForAllPreviousOpsAndReset(null, this.tableName.getNameAsString());
                if (error != null) {
                    if (this.listener == null) {
                        throw error;
                    }
                    this.listener.onException(error, this);
                }
            }
        }
        finally {
            this.currentWriteBufferSize = 0L;
            for (Row mut : this.writeAsyncBuffer) {
                if (!(mut instanceof Mutation)) continue;
                this.currentWriteBufferSize += ((Mutation)mut).heapSize();
            }
        }
    }

    @Deprecated
    public void setWriteBufferSize(long writeBufferSize) throws RetriesExhaustedWithDetailsException, InterruptedIOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize > writeBufferSize) {
            this.flush();
        }
    }

    @Override
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Deprecated
    public List<Row> getWriteBuffer() {
        return this.writeAsyncBuffer;
    }
}

