/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.test;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.primitives.Bytes;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@SuppressWarnings(value={"RV_ABSOLUTE_VALUE_OF_RANDOM_INT"}, justification="Should probably fix")
public class RedundantKVGenerator {
    static byte[] DEFAULT_COMMON_PREFIX = new byte[0];
    static int DEFAULT_NUMBER_OF_ROW_PREFIXES = 10;
    static int DEFAULT_AVERAGE_PREFIX_LENGTH = 6;
    static int DEFAULT_PREFIX_LENGTH_VARIANCE = 3;
    static int DEFAULT_AVERAGE_SUFFIX_LENGTH = 3;
    static int DEFAULT_SUFFIX_LENGTH_VARIANCE = 3;
    static int DEFAULT_NUMBER_OF_ROW = 500;
    static float DEFAULT_CHANCE_FOR_SAME_QUALIFIER = 0.5f;
    static float DEFAULT_CHANCE_FOR_SIMILIAR_QUALIFIER = 0.4f;
    static int DEFAULT_AVERAGE_QUALIFIER_LENGTH = 9;
    static int DEFAULT_QUALIFIER_LENGTH_VARIANCE = 3;
    static int DEFAULT_COLUMN_FAMILY_LENGTH = 9;
    static int DEFAULT_VALUE_LENGTH = 8;
    static float DEFAULT_CHANCE_FOR_ZERO_VALUE = 0.5f;
    static int DEFAULT_BASE_TIMESTAMP_DIVIDE = 1000000;
    static int DEFAULT_TIMESTAMP_DIFF_SIZE = 100000000;
    private Random randomizer;
    private byte[] commonPrefix;
    private int numberOfRowPrefixes;
    private int averagePrefixLength = 6;
    private int prefixLengthVariance = 3;
    private int averageSuffixLength = 3;
    private int suffixLengthVariance = 3;
    private int numberOfRows = 500;
    private byte[] family;
    private float chanceForSameQualifier = 0.5f;
    private float chanceForSimilarQualifier = 0.4f;
    private int averageQualifierLength = 9;
    private int qualifierLengthVariance = 3;
    private int columnFamilyLength = 9;
    private int valueLength = 8;
    private float chanceForZeroValue = 0.5f;
    private int baseTimestampDivide = 1000000;
    private int timestampDiffSize = 100000000;

    public RedundantKVGenerator() {
        this(new Random(42L), DEFAULT_NUMBER_OF_ROW_PREFIXES, DEFAULT_AVERAGE_PREFIX_LENGTH, DEFAULT_PREFIX_LENGTH_VARIANCE, DEFAULT_AVERAGE_SUFFIX_LENGTH, DEFAULT_SUFFIX_LENGTH_VARIANCE, DEFAULT_NUMBER_OF_ROW, DEFAULT_CHANCE_FOR_SAME_QUALIFIER, DEFAULT_CHANCE_FOR_SIMILIAR_QUALIFIER, DEFAULT_AVERAGE_QUALIFIER_LENGTH, DEFAULT_QUALIFIER_LENGTH_VARIANCE, DEFAULT_COLUMN_FAMILY_LENGTH, DEFAULT_VALUE_LENGTH, DEFAULT_CHANCE_FOR_ZERO_VALUE, DEFAULT_BASE_TIMESTAMP_DIVIDE, DEFAULT_TIMESTAMP_DIFF_SIZE);
    }

    public RedundantKVGenerator(Random randomizer, int numberOfRowPrefixes, int averagePrefixLength, int prefixLengthVariance, int averageSuffixLength, int suffixLengthVariance, int numberOfRows, float chanceForSameQualifier, float chanceForSimiliarQualifier, int averageQualifierLength, int qualifierLengthVariance, int columnFamilyLength, int valueLength, float chanceForZeroValue, int baseTimestampDivide, int timestampDiffSize) {
        this.randomizer = randomizer;
        this.commonPrefix = DEFAULT_COMMON_PREFIX;
        this.numberOfRowPrefixes = numberOfRowPrefixes;
        this.averagePrefixLength = averagePrefixLength;
        this.prefixLengthVariance = prefixLengthVariance;
        this.averageSuffixLength = averageSuffixLength;
        this.suffixLengthVariance = suffixLengthVariance;
        this.numberOfRows = numberOfRows;
        this.chanceForSameQualifier = chanceForSameQualifier;
        this.chanceForSimilarQualifier = chanceForSimiliarQualifier;
        this.averageQualifierLength = averageQualifierLength;
        this.qualifierLengthVariance = qualifierLengthVariance;
        this.columnFamilyLength = columnFamilyLength;
        this.valueLength = valueLength;
        this.chanceForZeroValue = chanceForZeroValue;
        this.baseTimestampDivide = baseTimestampDivide;
        this.timestampDiffSize = timestampDiffSize;
    }

    private List<byte[]> generateRows() {
        ArrayList<byte[]> prefixes = new ArrayList<byte[]>();
        prefixes.add(new byte[0]);
        for (int i = 1; i < this.numberOfRowPrefixes; ++i) {
            int prefixLength = this.averagePrefixLength;
            byte[] newPrefix = new byte[prefixLength += this.randomizer.nextInt(2 * this.prefixLengthVariance + 1) - this.prefixLengthVariance];
            this.randomizer.nextBytes(newPrefix);
            byte[] newPrefixWithCommon = newPrefix;
            prefixes.add(newPrefixWithCommon);
        }
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (int i = 0; i < this.numberOfRows; ++i) {
            int suffixLength = this.averageSuffixLength;
            int randomPrefix = this.randomizer.nextInt(prefixes.size());
            byte[] row = new byte[((byte[])prefixes.get(randomPrefix)).length + (suffixLength += this.randomizer.nextInt(2 * this.suffixLengthVariance + 1) - this.suffixLengthVariance)];
            byte[] rowWithCommonPrefix = Bytes.concat(this.commonPrefix, row);
            rows.add(rowWithCommonPrefix);
        }
        return rows;
    }

    public List<KeyValue> generateTestKeyValues(int howMany) {
        return this.generateTestKeyValues(howMany, false);
    }

    public List<KeyValue> generateTestKeyValues(int howMany, boolean useTags) {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        List<byte[]> rows = this.generateRows();
        HashMap rowsToQualifier = new HashMap();
        if (this.family == null) {
            this.family = new byte[this.columnFamilyLength];
            this.randomizer.nextBytes(this.family);
        }
        long baseTimestamp = Math.abs(this.randomizer.nextInt()) / this.baseTimestampDivide;
        byte[] value = new byte[this.valueLength];
        for (int i = 0; i < howMany; ++i) {
            byte[] qualifier;
            long timestamp = baseTimestamp;
            if (this.timestampDiffSize > 0) {
                timestamp += (long)this.randomizer.nextInt(this.timestampDiffSize);
            }
            Integer rowId = this.randomizer.nextInt(rows.size());
            byte[] row = rows.get(rowId);
            float qualifierChance = this.randomizer.nextFloat();
            if (!rowsToQualifier.containsKey(rowId) || qualifierChance > this.chanceForSameQualifier + this.chanceForSimilarQualifier) {
                int qualifierLength = this.averageQualifierLength;
                qualifier = new byte[qualifierLength += this.randomizer.nextInt(2 * this.qualifierLengthVariance + 1) - this.qualifierLengthVariance];
                this.randomizer.nextBytes(qualifier);
                if (!rowsToQualifier.containsKey(rowId)) {
                    rowsToQualifier.put(rowId, new ArrayList());
                }
                ((List)rowsToQualifier.get(rowId)).add(qualifier);
            } else if (qualifierChance > this.chanceForSameQualifier) {
                List previousQualifiers = (List)rowsToQualifier.get(rowId);
                byte[] originalQualifier = (byte[])previousQualifiers.get(this.randomizer.nextInt(previousQualifiers.size()));
                qualifier = new byte[originalQualifier.length];
                int commonPrefix = this.randomizer.nextInt(qualifier.length);
                System.arraycopy(originalQualifier, 0, qualifier, 0, commonPrefix);
                for (int j = commonPrefix; j < qualifier.length; ++j) {
                    qualifier[j] = (byte)(this.randomizer.nextInt() & 0xFF);
                }
                ((List)rowsToQualifier.get(rowId)).add(qualifier);
            } else {
                List previousQualifiers = (List)rowsToQualifier.get(rowId);
                qualifier = (byte[])previousQualifiers.get(this.randomizer.nextInt(previousQualifiers.size()));
            }
            if (this.randomizer.nextFloat() < this.chanceForZeroValue) {
                for (int j = 0; j < value.length; ++j) {
                    value[j] = 0;
                }
            } else {
                this.randomizer.nextBytes(value);
            }
            if (useTags) {
                result.add(new KeyValue(row, this.family, qualifier, timestamp, value, new Tag[]{new Tag(1, "value1")}));
                continue;
            }
            result.add(new KeyValue(row, this.family, qualifier, timestamp, value));
        }
        Collections.sort(result, KeyValue.COMPARATOR);
        return result;
    }

    public static ByteBuffer convertKvToByteBuffer(List<KeyValue> keyValues, boolean includesMemstoreTS) {
        int totalSize = 0;
        for (KeyValue kv : keyValues) {
            totalSize += kv.getLength();
            if (!includesMemstoreTS) continue;
            totalSize += WritableUtils.getVIntSize(kv.getMvccVersion());
        }
        ByteBuffer result = ByteBuffer.allocate(totalSize);
        for (KeyValue kv : keyValues) {
            result.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
            if (!includesMemstoreTS) continue;
            ByteBufferUtils.writeVLong(result, kv.getMvccVersion());
        }
        return result;
    }

    public RedundantKVGenerator setCommonPrefix(byte[] prefix) {
        this.commonPrefix = prefix;
        return this;
    }

    public RedundantKVGenerator setRandomizer(Random randomizer) {
        this.randomizer = randomizer;
        return this;
    }

    public RedundantKVGenerator setNumberOfRowPrefixes(int numberOfRowPrefixes) {
        this.numberOfRowPrefixes = numberOfRowPrefixes;
        return this;
    }

    public RedundantKVGenerator setAveragePrefixLength(int averagePrefixLength) {
        this.averagePrefixLength = averagePrefixLength;
        return this;
    }

    public RedundantKVGenerator setPrefixLengthVariance(int prefixLengthVariance) {
        this.prefixLengthVariance = prefixLengthVariance;
        return this;
    }

    public RedundantKVGenerator setAverageSuffixLength(int averageSuffixLength) {
        this.averageSuffixLength = averageSuffixLength;
        return this;
    }

    public RedundantKVGenerator setSuffixLengthVariance(int suffixLengthVariance) {
        this.suffixLengthVariance = suffixLengthVariance;
        return this;
    }

    public RedundantKVGenerator setNumberOfRows(int numberOfRows) {
        this.numberOfRows = numberOfRows;
        return this;
    }

    public RedundantKVGenerator setChanceForSameQualifier(float chanceForSameQualifier) {
        this.chanceForSameQualifier = chanceForSameQualifier;
        return this;
    }

    public RedundantKVGenerator setChanceForSimilarQualifier(float chanceForSimiliarQualifier) {
        this.chanceForSimilarQualifier = chanceForSimiliarQualifier;
        return this;
    }

    public RedundantKVGenerator setAverageQualifierLength(int averageQualifierLength) {
        this.averageQualifierLength = averageQualifierLength;
        return this;
    }

    public RedundantKVGenerator setQualifierLengthVariance(int qualifierLengthVariance) {
        this.qualifierLengthVariance = qualifierLengthVariance;
        return this;
    }

    public RedundantKVGenerator setColumnFamilyLength(int columnFamilyLength) {
        this.columnFamilyLength = columnFamilyLength;
        return this;
    }

    public RedundantKVGenerator setFamily(byte[] family) {
        this.family = family;
        this.columnFamilyLength = family.length;
        return this;
    }

    public RedundantKVGenerator setValueLength(int valueLength) {
        this.valueLength = valueLength;
        return this;
    }

    public RedundantKVGenerator setChanceForZeroValue(float chanceForZeroValue) {
        this.chanceForZeroValue = chanceForZeroValue;
        return this;
    }

    public RedundantKVGenerator setBaseTimestampDivide(int baseTimestampDivide) {
        this.baseTimestampDivide = baseTimestampDivide;
        return this;
    }

    public RedundantKVGenerator setTimestampDiffSize(int timestampDiffSize) {
        this.timestampDiffSize = timestampDiffSize;
        return this;
    }
}

