/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClientToAMTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_CLIENT_TOKEN");
    private ApplicationAttemptId applicationAttemptId;
    private Text clientName = new Text();

    public ClientToAMTokenIdentifier() {
    }

    public ClientToAMTokenIdentifier(ApplicationAttemptId id, String client) {
        this();
        this.applicationAttemptId = id;
        this.clientName = new Text(client);
    }

    public ApplicationAttemptId getApplicationAttemptID() {
        return this.applicationAttemptId;
    }

    public String getClientName() {
        return this.clientName.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.applicationAttemptId.getApplicationId().getClusterTimestamp());
        out.writeInt(this.applicationAttemptId.getApplicationId().getId());
        out.writeInt(this.applicationAttemptId.getAttemptId());
        this.clientName.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.applicationAttemptId = ApplicationAttemptId.newInstance(ApplicationId.newInstance(in.readLong(), in.readInt()), in.readInt());
        this.clientName.readFields(in);
    }

    @Override
    public Text getKind() {
        return KIND_NAME;
    }

    @Override
    public UserGroupInformation getUser() {
        if (this.clientName == null) {
            return null;
        }
        return UserGroupInformation.createRemoteUser(this.clientName.toString());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        @Override
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

