/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationResourceUsageReport {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationResourceUsageReport newInstance(int numUsedContainers, int numReservedContainers, Resource usedResources, Resource reservedResources, Resource neededResources) {
        ApplicationResourceUsageReport report = Records.newRecord(ApplicationResourceUsageReport.class);
        report.setNumUsedContainers(numUsedContainers);
        report.setNumReservedContainers(numReservedContainers);
        report.setUsedResources(usedResources);
        report.setReservedResources(reservedResources);
        report.setNeededResources(neededResources);
        return report;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getNumUsedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNumUsedContainers(int var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract int getNumReservedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNumReservedContainers(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getUsedResources();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUsedResources(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getReservedResources();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setReservedResources(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getNeededResources();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNeededResources(Resource var1);
}

