/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class NamespaceDescriptor {
    public static final byte[] SYSTEM_NAMESPACE_NAME = Bytes.toBytes("hbase");
    public static final String SYSTEM_NAMESPACE_NAME_STR = Bytes.toString(SYSTEM_NAMESPACE_NAME);
    public static final byte[] DEFAULT_NAMESPACE_NAME = Bytes.toBytes("default");
    public static final String DEFAULT_NAMESPACE_NAME_STR = Bytes.toString(DEFAULT_NAMESPACE_NAME);
    public static final NamespaceDescriptor DEFAULT_NAMESPACE = NamespaceDescriptor.create(DEFAULT_NAMESPACE_NAME_STR).build();
    public static final NamespaceDescriptor SYSTEM_NAMESPACE = NamespaceDescriptor.create(SYSTEM_NAMESPACE_NAME_STR).build();
    public static final Set<String> RESERVED_NAMESPACES;
    public static final Set<byte[]> RESERVED_NAMESPACES_BYTES;
    private String name;
    private Map<String, String> configuration;
    public static final Comparator<NamespaceDescriptor> NAMESPACE_DESCRIPTOR_COMPARATOR;

    private NamespaceDescriptor() {
    }

    private NamespaceDescriptor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigurationValue(String key) {
        return this.configuration.get(key);
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public void setConfiguration(String key, String value) {
        if (value == null) {
            this.removeConfiguration(key);
        } else {
            this.configuration.put(key, value);
        }
    }

    public void removeConfiguration(String key) {
        this.configuration.remove(key);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(this.name);
        s.append("'");
        for (Map.Entry<String, String> e : this.configuration.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (key == null) continue;
            s.append(", ");
            s.append(key);
            s.append(" => '");
            s.append(value);
            s.append("'");
        }
        s.append('}');
        return s.toString();
    }

    public static Builder create(String name) {
        return new Builder(name);
    }

    public static Builder create(NamespaceDescriptor ns) {
        return new Builder(ns);
    }

    static {
        AbstractSet set = new HashSet<String>();
        set.add(DEFAULT_NAMESPACE_NAME_STR);
        set.add(SYSTEM_NAMESPACE_NAME_STR);
        RESERVED_NAMESPACES = Collections.unmodifiableSet(set);
        set = new TreeSet<byte[]>(Bytes.BYTES_RAWCOMPARATOR);
        for (String name : RESERVED_NAMESPACES) {
            set.add(Bytes.toBytes(name));
        }
        RESERVED_NAMESPACES_BYTES = Collections.unmodifiableSet(set);
        NAMESPACE_DESCRIPTOR_COMPARATOR = new Comparator<NamespaceDescriptor>(){

            @Override
            public int compare(NamespaceDescriptor namespaceDescriptor, NamespaceDescriptor namespaceDescriptor2) {
                return namespaceDescriptor.getName().compareTo(namespaceDescriptor2.getName());
            }
        };
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Builder {
        private String bName;
        private Map<String, String> bConfiguration = new TreeMap<String, String>();

        private Builder(NamespaceDescriptor ns) {
            this.bName = ns.name;
            this.bConfiguration = ns.configuration;
        }

        private Builder(String name) {
            this.bName = name;
        }

        public Builder addConfiguration(Map<String, String> configuration) {
            this.bConfiguration.putAll(configuration);
            return this;
        }

        public Builder addConfiguration(String key, String value) {
            this.bConfiguration.put(key, value);
            return this;
        }

        public Builder removeConfiguration(String key) {
            this.bConfiguration.remove(key);
            return this;
        }

        public NamespaceDescriptor build() {
            if (this.bName == null) {
                throw new IllegalArgumentException("A name has to be specified in a namespace.");
            }
            NamespaceDescriptor desc = new NamespaceDescriptor(this.bName);
            desc.configuration = this.bConfiguration;
            return desc;
        }
    }
}

