/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public abstract class RegionAdminServiceCallable<T>
implements RetryingCallable<T> {
    protected final ClusterConnection connection;
    protected final RpcControllerFactory rpcControllerFactory;
    protected AdminProtos.AdminService.BlockingInterface stub;
    protected HRegionLocation location;
    protected final TableName tableName;
    protected final byte[] row;
    protected final int replicaId;
    protected static final int MIN_WAIT_DEAD_SERVER = 10000;

    public RegionAdminServiceCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, TableName tableName, byte[] row) {
        this(connection, rpcControllerFactory, null, tableName, row);
    }

    public RegionAdminServiceCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, HRegionLocation location, TableName tableName, byte[] row) {
        this(connection, rpcControllerFactory, location, tableName, row, 0);
    }

    public RegionAdminServiceCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, HRegionLocation location, TableName tableName, byte[] row, int replicaId) {
        this.connection = connection;
        this.rpcControllerFactory = rpcControllerFactory;
        this.location = location;
        this.tableName = tableName;
        this.row = row;
        this.replicaId = replicaId;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (reload || this.location == null) {
            this.location = this.getLocation(!reload);
        }
        if (this.location == null) {
            throw new HBaseIOException(this.getExceptionMessage());
        }
        this.setStub(this.connection.getAdmin(this.location.getServerName()));
    }

    protected void setStub(AdminProtos.AdminService.BlockingInterface stub) {
        this.stub = stub;
    }

    public HRegionLocation getLocation(boolean useCache) throws IOException {
        RegionLocations rl = RegionAdminServiceCallable.getRegionLocations(this.connection, this.tableName, this.row, useCache, this.replicaId);
        if (rl == null) {
            throw new HBaseIOException(this.getExceptionMessage());
        }
        HRegionLocation location = rl.getRegionLocation(this.replicaId);
        if (location == null) {
            throw new HBaseIOException(this.getExceptionMessage());
        }
        return location;
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
        if (this.location != null) {
            this.connection.updateCachedLocations(this.tableName, this.location.getRegionInfo().getRegionName(), this.row, t, this.location.getServerName());
        }
    }

    HConnection getConnection() {
        return this.connection;
    }

    protected String getExceptionMessage() {
        return "There is no location table=" + this.tableName + " ,replica=" + this.replicaId + ", row=" + Bytes.toStringBinary(this.row);
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return null;
    }

    @Override
    public long sleep(long pause, int tries) {
        long sleep = ConnectionUtils.getPauseTime(pause, tries);
        if (sleep < 10000L && (this.location == null || this.connection.isDeadServer(this.location.getServerName()))) {
            sleep = ConnectionUtils.addJitter(10000L, 0.1f);
        }
        return sleep;
    }

    public static RegionLocations getRegionLocations(ClusterConnection connection, TableName tableName, byte[] row, boolean useCache, int replicaId) throws RetriesExhaustedException, DoNotRetryIOException, InterruptedIOException {
        RegionLocations rl;
        try {
            rl = connection.locateRegion(tableName, row, useCache, true, replicaId);
        }
        catch (DoNotRetryIOException e) {
            throw e;
        }
        catch (NeedUnmanagedConnectionException e) {
            throw new DoNotRetryIOException(e);
        }
        catch (RetriesExhaustedException e) {
            throw e;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RetriesExhaustedException("Can't get the location", e);
        }
        if (rl == null) {
            throw new RetriesExhaustedException("Can't get the locations");
        }
        return rl;
    }
}

