/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx;

import java.net.URI;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.HttpMethod;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.HttpVersion;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.apache.hadoop.hbase.shaded.io.netty.util.CharsetUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.logging.InternalLogger;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class WebSocketClientHandshaker13
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker13.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;

    public WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        URI wsURL = this.uri();
        String path = WebSocketClientHandshaker13.rawPath(wsURL);
        byte[] nonce = WebSocketUtil.randomBytes(16);
        String key = WebSocketUtil.base64(nonce);
        String acceptSeed = key + MAGIC_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 client handshake key: {}, expected response: {}", (Object)key, (Object)this.expectedChallengeResponseString);
        }
        int wsPort = WebSocketClientHandshaker13.websocketPort(wsURL);
        String host = wsURL.getHost();
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        HttpHeaders headers = request.headers();
        headers.add("Upgrade", (Object)"WebSocket").add("Connection", (Object)"Upgrade").add("Sec-WebSocket-Key", (Object)key).add("Host", (Object)WebSocketClientHandshaker13.websocketHostValue(wsURL)).add("Sec-WebSocket-Origin", (Object)WebSocketClientHandshaker13.websocketOriginValue(host, wsPort));
        String expectedSubprotocol = this.expectedSubprotocol();
        if (expectedSubprotocol != null && !expectedSubprotocol.isEmpty()) {
            headers.add("Sec-WebSocket-Protocol", (Object)expectedSubprotocol);
        }
        headers.add("Sec-WebSocket-Version", (Object)"13");
        if (this.customHeaders != null) {
            headers.add(this.customHeaders);
        }
        return request;
    }

    @Override
    protected void verify(FullHttpResponse response) {
        HttpResponseStatus status = HttpResponseStatus.SWITCHING_PROTOCOLS;
        HttpHeaders headers = response.headers();
        if (!response.getStatus().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response getStatus: " + response.getStatus());
        }
        String upgrade = headers.get("Upgrade");
        if (!"WebSocket".equalsIgnoreCase(upgrade)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + upgrade);
        }
        if (!headers.containsValue("Connection", "Upgrade", true)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + headers.get("Connection"));
        }
        String accept = headers.get("Sec-WebSocket-Accept");
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString));
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(true);
    }
}

